/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bundles.exception;

import com.tc.bundles.DependencyStack;
import com.tc.bundles.MavenToOSGi;
import com.tc.bundles.OSGiToMaven;
import com.tc.bundles.Repository;
import com.tc.bundles.ResolverUtils;
import com.tc.bundles.exception.BundleExceptionSummary;
import com.tc.util.Assert;
import com.tc.util.runtime.Os;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingBundleException
extends BundleException
implements BundleExceptionSummary {
    private final String groupId;
    private final String name;
    private final String version;
    private final List<Repository> repositories;
    private final DependencyStack dependencyStack;

    public MissingBundleException(String msg, String groupId, String name, String version, List<Repository> repositories, DependencyStack dependencyStack) {
        super(msg);
        Assert.assertNotNull(groupId);
        Assert.assertNotNull(name);
        Assert.assertNotNull(version);
        Assert.assertNotNull(repositories);
        Assert.assertNotNull(dependencyStack);
        this.groupId = groupId;
        this.name = name;
        this.version = version;
        this.repositories = repositories;
        this.dependencyStack = dependencyStack;
    }

    public MissingBundleException(String msg, String groupId, String name, String version, List<Repository> repositories) {
        this(msg, groupId, name, version, repositories, new DependencyStack());
    }

    private String expectedPaths() {
        StringBuffer repos = new StringBuffer();
        List<URL> urls = ResolverUtils.searchRepos(this.repositories, this.groupId, this.name, this.version);
        for (URL url : urls) {
            repos.append("+ ").append(url).append("\n").append("      ");
        }
        return repos.toString();
    }

    private String searchAttributes() {
        return "groupId: " + this.groupId + "\n" + "   " + "   " + "name   : " + this.name + "\n" + "   " + "   " + "version: " + OSGiToMaven.bundleVersionToProjectVersion(this.version);
    }

    private String expectedAttributes() {
        return "Bundle-SymbolicName: " + MavenToOSGi.artifactIdToSymbolicName(this.groupId, this.name) + "\n" + "   " + "   " + "Bundle-Version     : " + MavenToOSGi.projectVersionToBundleVersion(this.version);
    }

    private String searchedRepositories() {
        StringBuffer repos = new StringBuffer();
        for (int j = 0; j < this.repositories.size(); ++j) {
            String root = ResolverUtils.canonicalize(this.repositories.get(j).describe());
            repos.append("+ ").append(root).append("\n").append("      ");
        }
        return repos.toString();
    }

    @Override
    public String getSummary() {
        StringBuffer buf = new StringBuffer(this.getMessage()).append("\n\n").append("   ");
        buf.append("Attempted to resolve the TIM using the following descriptors:\n\n").append("      ");
        buf.append(this.searchAttributes()).append("\n\n").append("   ");
        buf.append("Expected the TIM's filename to be:\n\n").append("      ");
        buf.append(OSGiToMaven.makeBundleFilename(this.name, this.version)).append("\n\n").append("   ");
        buf.append("Expected these attributes to be in the manifest:\n\n").append("      ");
        buf.append(this.expectedAttributes()).append("\n\n").append("   ");
        if (this.repositories.size() == 0) {
            buf.append("There were no repositories declared where the TIM might have been installed.\n\n");
        } else {
            buf.append("Searched using the following repositories:\n\n").append("      ");
            buf.append(this.searchedRepositories()).append("\n").append("   ");
            buf.append("Tried to resolve the jar file using the following paths:\n\n").append("      ");
            buf.append(this.expectedPaths()).append("\n").append("   ");
        }
        if (this.dependencyStack.size() > 0) {
            buf.append("The following shows the dependencies path the resolver took and why it ");
            buf.append("needed to locate the missing TIM:\n\n");
            buf.append(this.dependencyStackAsString()).append("\n").append("   ");
        }
        buf.append("If the jar file exists and is in one of the paths listed ");
        buf.append("above, make sure that the Bundle-SymbolicName and\n").append("   ");
        buf.append("Bundle-Version attribute in its manifest matches the ones ");
        buf.append("that the resolver expects.\n\n").append("   ");
        buf.append("If you do not have this particular TIM or any of its ");
        buf.append("dependencies installed, try using the tim-get tool's \n").append("   ");
        buf.append("'install' command:\n\n").append("      ");
        String promptname = Os.isWindows() ? "C:\\> " : "$ ";
        String scriptname = Os.isWindows() ? "tim-get.bat" : "tim-get.sh";
        buf.append(promptname).append(scriptname).append(" install ");
        buf.append(this.name).append(" ").append(OSGiToMaven.bundleVersionToProjectVersion(this.version)).append(" ").append(this.groupId);
        buf.append("\n\n").append("   ");
        buf.append("You can also use the tool's 'list' command to see if it's actually available:\n\n").append("      ");
        buf.append(promptname).append(scriptname).append(" list ").append(this.name);
        buf.append("   ").append("# list anything that has '").append(this.name).append("' in it's name");
        buf.append("\n").append("      ");
        buf.append(promptname).append(scriptname).append(" list ").append(StringUtils.repeat((String)" ", (int)this.name.length()));
        buf.append("   ").append("# or, list everything that is available");
        buf.append("\n\n").append("   ");
        buf.append("For more information on how to use the tim-get tool, invoke:\n\n").append("      ");
        buf.append(promptname).append(scriptname).append(" help ");
        return StringUtils.replace((String)buf.toString(), (String)"\n", (String)System.getProperty("line.separator"));
    }

    private String dependencyStackAsString() {
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        BufferedOutputStream buf = new BufferedOutputStream(bas);
        MissingBundleException.printDependencyStack(this.dependencyStack, 0, 4, buf);
        return bas.toString();
    }

    private static void printDependencyStack(DependencyStack dependencies, int depth, int indent, OutputStream out) {
        try {
            for (Object entry : dependencies) {
                if (entry instanceof DependencyStack) {
                    MissingBundleException.printDependencyStack((DependencyStack)entry, depth + 1, indent, out);
                    continue;
                }
                if (depth == 0) {
                    out.write(("      " + entry.toString() + "\n").getBytes());
                    continue;
                }
                out.write("      ".getBytes());
                for (int j = 0; j < (depth - 1) * indent; ++j) {
                    out.write(" ".getBytes());
                }
                out.write(("+- " + entry.toString() + "\n").getBytes());
            }
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

