/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bundles.exception;

import com.tc.bundles.BundleSpec;
import org.osgi.framework.BundleException;

public class BundleSpecException
extends BundleException {
    public BundleSpecException(String msg) {
        super(msg);
    }

    public static BundleSpecException unspecifiedVersion(BundleSpec spec) {
        String msg = "Incomplete bundle spec, the version number must also be supplied in order to locate the bundle named '" + spec.getName() + "'";
        if (spec.getGroupId().length() > 0) {
            msg = msg + " (group-id: " + spec.getGroupId() + ")";
        }
        return new UnspecifiedVersion(msg);
    }

    public static BundleSpecException absoluteVersionRequired(BundleSpec spec) {
        String msg = "Unsupported bundle spec, the version number supplied must be absolute in order to locate the bundle named '" + spec.getName() + "'";
        if (spec.getGroupId().length() > 0) {
            msg = msg + " (group-id: " + spec.getGroupId() + ")";
        }
        return new UnsupportedSpec(msg);
    }

    static class UnsupportedSpec
    extends BundleSpecException {
        public UnsupportedSpec(String msg) {
            super(msg);
        }
    }

    static class UnspecifiedVersion
    extends BundleSpecException {
        public UnspecifiedVersion(String msg) {
            super(msg);
        }
    }
}

