/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bundles;

import com.tc.bundles.OSGiToMaven;
import com.tc.bundles.Repository;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualTimRepository
implements Repository {
    private final Map<String, URL> virtualTimJars;

    public VirtualTimRepository(Map<String, URL> virtualTimJars) {
        this.virtualTimJars = new HashMap<String, URL>(virtualTimJars);
    }

    @Override
    public Collection<URL> search(String groupId, String name, String version) {
        String key = OSGiToMaven.makeBundleFilename(name, version);
        URL url = this.virtualTimJars.get(key);
        if (url != null) {
            return Collections.singletonList(url);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Collection<URL> search(String groupId, String symName) {
        ArrayList<URL> rv = new ArrayList<URL>();
        for (Map.Entry<String, URL> e : this.virtualTimJars.entrySet()) {
            if (!e.getKey().startsWith(symName)) continue;
            rv.add(e.getValue());
        }
        return rv;
    }

    @Override
    public String describe() {
        return this.getClass().getSimpleName() + this.virtualTimJars;
    }
}

