/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bundles;

import com.tc.bundles.Repository;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResolverUtils {
    public static List<URL> searchRepos(List<Repository> repositories, String groupId, String name, String version) {
        ArrayList<URL> paths = new ArrayList<URL>();
        for (Repository repo : repositories) {
            paths.addAll(repo.search(groupId, name, version));
        }
        return paths;
    }

    public static String[] urlsToStrings(URL[] urls) {
        String[] strs = new String[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            File f = FileUtils.toFile((URL)urls[i]);
            strs[i] = f != null ? f.getAbsolutePath() : urls[i].toExternalForm();
        }
        return strs;
    }

    public static String canonicalize(URL url) {
        File path = FileUtils.toFile((URL)url);
        if (path == null) {
            return url.toString();
        }
        return ResolverUtils.canonicalize(path);
    }

    public static String canonicalize(File path) {
        try {
            return path.getCanonicalPath();
        }
        catch (IOException e) {
            return path.toString();
        }
    }

    public static String canonicalize(String path) {
        return ResolverUtils.canonicalize(new File(path));
    }
}

