/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bundles;

import com.tc.bundles.BundleSpec;
import com.tc.bundles.BundleSpecImpl;
import com.tc.bundles.ConflictingModuleException;
import com.tc.bundles.DependencyStack;
import com.tc.bundles.FSRepository;
import com.tc.bundles.MavenToOSGi;
import com.tc.bundles.OSGiToMaven;
import com.tc.bundles.Repository;
import com.tc.bundles.ResolverUtils;
import com.tc.bundles.Version;
import com.tc.bundles.exception.BundleSpecException;
import com.tc.bundles.exception.MissingBundleException;
import com.tc.bundles.exception.MissingDefaultRepositoryException;
import com.tc.bundles.exception.UnreadableBundleException;
import com.tc.logging.CustomerLogging;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.properties.TCProperties;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import com.tc.util.version.VersionMatcher;
import com.terracottatech.config.Module;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolver {
    static final String BUNDLE_VERSION = "Bundle-Version";
    static final String BUNDLE_SYMBOLICNAME = "Bundle-SymbolicName";
    private static final String TC_PROPERTIES_SECTION = "l1.modules";
    private static final TCLogger logger = TCLogging.getLogger(Resolver.class);
    private final List<Repository> repositories = new ArrayList<Repository>();
    private final List<Entry> registry = new ArrayList<Entry>();
    private final VersionMatcher versionMatcher;
    private static final TCLogger consoleLogger = CustomerLogging.getConsoleLogger();
    private static final ResourceBundle resourceBundle;

    public Resolver(String[] repositoryStrings, String tcVersion, String apiVersion) throws MissingDefaultRepositoryException {
        this(repositoryStrings, true, tcVersion, apiVersion);
    }

    public Resolver(String[] repositoryStrings, boolean injectDefault, String tcVersion, String apiVersion) throws MissingDefaultRepositoryException {
        this(repositoryStrings, injectDefault, tcVersion, apiVersion, Collections.EMPTY_LIST);
    }

    public Resolver(String[] repositoryStrings, boolean injectDefault, String tcVersion, String apiVersion, Collection<Repository> addlRepos) throws MissingDefaultRepositoryException {
        this.repositories.addAll(addlRepos);
        if (injectDefault) {
            this.injectDefaultRepositories();
        }
        for (String repositoryString : repositoryStrings) {
            File repoFile;
            String repository = repositoryString.trim();
            if (repository.length() == 0 || (repoFile = Resolver.resolveRepositoryLocation(repository)) == null) continue;
            this.repositories.add(new FSRepository(repoFile, logger));
        }
        if (this.repositories.isEmpty()) {
            String msg = "No valid TIM repository locations defined.";
            throw new MissingDefaultRepositoryException("No valid TIM repository locations defined.");
        }
        this.versionMatcher = new VersionMatcher(tcVersion, apiVersion);
    }

    private void injectDefaultRepositories() throws MissingDefaultRepositoryException {
        String[] entries;
        TCProperties props;
        String reposProp;
        String installRoot = System.getProperty("tc.install-root");
        if (installRoot != null) {
            File defaultRepository = new File(installRoot, "modules");
            if (Resolver.resolveRepositoryLocation(defaultRepository.getPath()) == null) {
                String msg = "The default TIM repository does not exist.";
                throw new MissingDefaultRepositoryException("The default TIM repository does not exist.", defaultRepository);
            }
            consoleLogger.debug("Appending default TIM repository: '" + defaultRepository + "'");
            this.repositories.add(new FSRepository(defaultRepository, logger));
        }
        String string = reposProp = (props = TCPropertiesImpl.getProperties().getPropertiesFor(TC_PROPERTIES_SECTION)) != null ? props.getProperty("repositories", true) : null;
        if (reposProp == null) {
            return;
        }
        for (String entry : entries = reposProp.split(",")) {
            String trimmed = entry.trim();
            if (trimmed.length() == 0) continue;
            File repoFile = Resolver.resolveRepositoryLocation(trimmed);
            if (repoFile == null) {
                consoleLogger.warn("Ignored non-existent TIM repository: '" + ResolverUtils.canonicalize(trimmed) + "'");
                continue;
            }
            consoleLogger.debug("Prepending default TIM repository: '" + ResolverUtils.canonicalize(repoFile) + "'");
            this.repositories.add(new FSRepository(repoFile, logger));
        }
    }

    static File resolveRepositoryLocation(String repository) {
        Assert.assertNotNull(repository);
        File file = new File(repository);
        if (file.isDirectory()) {
            return file;
        }
        URL url = null;
        try {
            url = new URL(repository);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url == null) {
            consoleLogger.warn("Skipping repository location: '" + repository + "', it either does not exist or is not a directory; make sure that the path '" + ResolverUtils.canonicalize(repository) + "' actually exists.");
            return null;
        }
        if (!url.getProtocol().equalsIgnoreCase("file")) {
            consoleLogger.warn("Skipping repository URL: '" + repository + "', only the 'file:' protocol is supported.");
            return null;
        }
        file = FileUtils.toFile((URL)url);
        if (!file.isDirectory()) {
            consoleLogger.warn("Skipping repository URL: '" + repository + "', it either does not exist nor resolve to a directory.");
            return null;
        }
        consoleLogger.warn("Repository location: '" + repository + "' defined as URL, this usage is deprecated and will be removed in the future.");
        return file;
    }

    public final URL resolve(Module module) throws BundleException {
        URL location;
        String name = module.getName();
        String version = module.getVersion();
        String groupId = module.getGroupId();
        if (version == null) {
            version = this.findNewestVersion(groupId, name);
            module.setVersion(version);
            if (version == null) {
                String msg = "No version was specified for " + groupId + ":" + name + " in the Terracotta configuration file and no versions were found in the available repositories.";
                throw new BundleException(msg);
            }
        }
        if (name == null) {
            String msg = "Invalid module specification (name is required): name=null, version=" + version + ", groupId=" + groupId;
            throw new BundleException(msg);
        }
        try {
            location = this.resolveLocation(name, version, groupId);
        }
        catch (Exception e) {
            String msg = "Invalid module specification: name=" + name + ", version=" + version + ", groupId=" + groupId;
            throw new BundleException(msg, (Throwable)e);
        }
        if (location == null) {
            String msg = Resolver.formatMessage(Message.ERROR_BUNDLE_UNRESOLVED, new Object[]{name, version, groupId});
            throw new MissingBundleException(msg, groupId, name, version, this.repositories);
        }
        logger.info("Resolved TIM " + groupId + ":" + name + ":" + version + " from " + location);
        DependencyStack dependencyStack = new DependencyStack();
        dependencyStack.push(module.getGroupId(), module.getName(), module.getVersion());
        this.resolveDependencies(location, dependencyStack);
        return location;
    }

    private String findNewestVersion(String groupId, String name) {
        String symName = MavenToOSGi.artifactIdToSymbolicName(groupId, name);
        String newestVersion = null;
        for (Repository repo : this.repositories) {
            Collection<URL> possibles = repo.search(groupId, name);
            for (URL possible : possibles) {
                String moduleApiVersion;
                Manifest manifest = Resolver.getManifest(possible);
                if (manifest == null) {
                    this.warn(Message.WARN_FILE_IGNORED_MISSING_MANIFEST, new Object[]{possible});
                    continue;
                }
                if (!symName.equals(manifest.getMainAttributes().getValue(BUNDLE_SYMBOLICNAME))) continue;
                String moduleTcVersion = manifest.getMainAttributes().getValue("tc-version");
                if (moduleTcVersion == null) {
                    moduleTcVersion = "*";
                }
                if ((moduleApiVersion = manifest.getMainAttributes().getValue("api-version")) == null) {
                    moduleApiVersion = "*";
                    String requiredBundles = manifest.getMainAttributes().getValue("Require-Bundle");
                    if (requiredBundles != null) {
                        String[] specs;
                        for (String spec : specs = requiredBundles.split(",")) {
                            BundleSpecImpl bundleSpec = new BundleSpecImpl(spec);
                            if (!((BundleSpec)bundleSpec).getSymbolicName().equals("org.terracotta.modules.modules-base")) continue;
                            moduleApiVersion = OSGiToMaven.bundleVersionToProjectVersion(((BundleSpec)bundleSpec).getVersion());
                            break;
                        }
                    }
                }
                if (!this.versionMatcher.matches(moduleTcVersion, moduleApiVersion)) continue;
                newestVersion = Resolver.newerVersion(newestVersion, manifest.getMainAttributes().getValue(BUNDLE_VERSION));
                logger.info("new version = " + newestVersion);
            }
        }
        return newestVersion;
    }

    static String newerVersion(String v1, String v2) {
        if (v1 == null) {
            if (v2 == null) {
                return null;
            }
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        org.osgi.framework.Version v1v = new org.osgi.framework.Version(v1);
        org.osgi.framework.Version v2v = new org.osgi.framework.Version(v2);
        if (v1v.compareTo((Object)v2v) > 0) {
            return v1;
        }
        return v2;
    }

    public final URL[] resolve(Module[] modules) throws BundleException {
        this.resolveDefaultModules();
        this.resolveAdditionalModules();
        for (int i = 0; modules != null && i < modules.length; ++i) {
            this.resolve(modules[i]);
        }
        return this.getResolvedURLs();
    }

    public final URL[] getResolvedURLs() {
        int i = 0;
        URL[] files = new URL[this.registry.size()];
        for (Entry entry : this.registry) {
            files[i++] = entry.getLocation();
        }
        return files;
    }

    private URL findJar(String groupId, String name, String version, Check check) {
        if (logger.isDebugEnabled()) {
            logger.debug("Resolving location of " + groupId + ":" + name + ":" + version);
        }
        URL best = null;
        org.osgi.framework.Version bestVersion = null;
        List<URL> urls = ResolverUtils.searchRepos(this.repositories, groupId, name, version);
        for (URL url : urls) {
            Manifest manifest = Resolver.getManifest(url);
            if (manifest == null) {
                this.warn(Message.WARN_FILE_IGNORED_MISSING_MANIFEST, new Object[]{url});
                continue;
            }
            if (!check.check(url, manifest)) continue;
            String currentVersionStr = manifest.getMainAttributes().getValue(BUNDLE_VERSION);
            if (best == null) {
                best = url;
                bestVersion = new org.osgi.framework.Version(currentVersionStr);
                continue;
            }
            org.osgi.framework.Version currentVersion = new org.osgi.framework.Version(currentVersionStr);
            if (currentVersion.compareTo((Object)bestVersion) <= 0) continue;
            best = url;
            bestVersion = currentVersion;
        }
        return best;
    }

    protected URL resolveBundle(final BundleSpec spec) {
        String groupId = spec.getGroupId();
        String name = spec.getName();
        String version = spec.getVersion();
        Check check = new Check(){

            public boolean check(URL bundle, Manifest manifest) {
                String n = manifest.getMainAttributes().getValue(Resolver.BUNDLE_SYMBOLICNAME);
                String v = manifest.getMainAttributes().getValue(Resolver.BUNDLE_VERSION);
                return spec.isCompatible(n, v);
            }
        };
        return this.findJar(groupId, name, version, check);
    }

    protected URL resolveLocation(String name, String version, String groupId) {
        Version osgiVersion;
        final String symname = MavenToOSGi.artifactIdToSymbolicName(groupId, name);
        Check check = new Check(osgiVersion = Version.parse(MavenToOSGi.projectVersionToBundleVersion(version))){
            final /* synthetic */ Version val$osgiVersion;
            {
                this.val$osgiVersion = version;
            }

            public boolean check(URL bundle, Manifest manifest) {
                return Resolver.this.isBundleMatch(bundle, manifest, symname, this.val$osgiVersion);
            }
        };
        URL jar = this.findJar(groupId, name, version, check);
        if (jar != null) {
            this.addToRegistry(jar, Resolver.getManifest(jar));
        }
        return jar;
    }

    private boolean isBundleMatch(URL bundle, Manifest manifest, String symname, Version version) {
        Assert.assertNotNull(manifest);
        if (logger.isDebugEnabled()) {
            logger.debug("Checking " + bundle + " for " + symname + ":" + (Object)((Object)version));
        }
        String bundlesymname = manifest.getMainAttributes().getValue(BUNDLE_SYMBOLICNAME);
        String bundleversion = manifest.getMainAttributes().getValue(BUNDLE_VERSION);
        try {
            return BundleSpec.isMatchingSymbolicName(symname, bundlesymname) && version.equals((Object)Version.parse(bundleversion));
        }
        catch (NumberFormatException e) {
            consoleLogger.warn("Bad version attribute in TIM manifest from jar file: '" + ResolverUtils.canonicalize(bundle) + "', version='" + bundleversion + "'.  Skipping...", e);
            return false;
        }
    }

    private void resolveDefaultModules() throws BundleException {
        String defaultModulesProp;
        TCProperties props = TCPropertiesImpl.getProperties().getPropertiesFor(TC_PROPERTIES_SECTION);
        String string = defaultModulesProp = props != null ? props.getProperty("default") : null;
        if (defaultModulesProp == null) {
            consoleLogger.debug("No implicit modules were loaded because the l1.modules.default property is not set.");
            return;
        }
        String[] defaultModulesSpec = BundleSpec.getRequirements(defaultModulesProp);
        if (defaultModulesSpec.length > 0) {
            for (String defaultSpec : defaultModulesSpec) {
                BundleSpec spec = BundleSpec.newInstance(defaultSpec);
                DependencyStack dependencyStack = new DependencyStack();
                dependencyStack.push(spec.getSymbolicName(), spec.getVersion());
                this.ensureBundle(spec, dependencyStack);
            }
            return;
        }
        consoleLogger.debug("No implicit modules were loaded because the l1.modules.default property is empty.");
    }

    private void resolveAdditionalModules() throws BundleException {
        String[] additionalModulesSpec;
        String additionalModulesProp;
        TCProperties props = TCPropertiesImpl.getProperties().getPropertiesFor(TC_PROPERTIES_SECTION);
        String string = additionalModulesProp = props != null ? props.getProperty("additional") : null;
        if (additionalModulesProp == null) {
            return;
        }
        for (String addlSpec : additionalModulesSpec = BundleSpec.getRequirements(additionalModulesProp)) {
            BundleSpec spec = BundleSpec.newInstance(addlSpec);
            DependencyStack dependencyStack = new DependencyStack();
            dependencyStack.push(spec.getSymbolicName(), spec.getVersion());
            this.ensureBundle(spec, dependencyStack);
        }
    }

    private BundleSpec[] getRequirements(Manifest manifest) {
        String[] manifestRequirements;
        ArrayList<BundleSpec> requirementList = new ArrayList<BundleSpec>();
        for (String manifestRequirement : manifestRequirements = BundleSpec.getRequirements(manifest)) {
            requirementList.add(BundleSpec.newInstance(manifestRequirement));
        }
        return requirementList.toArray(new BundleSpec[0]);
    }

    private void resolveDependencies(URL location, DependencyStack dependencyStack) throws BundleException {
        Manifest manifest = Resolver.getManifest(location);
        if (manifest == null) {
            String msg = Resolver.formatMessage(Message.ERROR_BUNDLE_UNREADABLE, new Object[]{ResolverUtils.canonicalize(location)});
            throw new UnreadableBundleException(msg, location);
        }
        BundleSpec[] requirements = this.getRequirements(manifest);
        DependencyStack stack = dependencyStack.push(new DependencyStack());
        for (BundleSpec spec : requirements) {
            stack.push(spec.getSymbolicName(), spec.getVersion());
            try {
                this.ensureBundle(spec, stack);
            }
            catch (MissingBundleException e) {
                throw new MissingBundleException(e.getMessage(), spec.getGroupId(), spec.getName(), spec.getVersion(), this.repositories, dependencyStack);
            }
        }
        this.addToRegistry(location, manifest);
    }

    static void validateBundleSpec(BundleSpec spec) throws BundleException {
        if (!spec.isVersionSpecified()) {
            throw BundleSpecException.unspecifiedVersion(spec);
        }
    }

    private void ensureBundle(BundleSpec spec, DependencyStack stack) throws BundleException {
        Resolver.validateBundleSpec(spec);
        URL required = this.findInRegistry(spec);
        if (required == null) {
            required = this.resolveBundle(spec);
            if (required == null) {
                String msg = Resolver.formatMessage(Message.ERROR_BUNDLE_DEPENDENCY_UNRESOLVED, new Object[]{spec.getName(), spec.getVersion(), spec.getGroupId()});
                throw new MissingBundleException(msg, spec.getGroupId(), spec.getName(), spec.getVersion(), this.repositories, stack);
            }
            this.addToRegistry(required, Resolver.getManifest(required));
            this.resolveDependencies(required, stack);
        }
    }

    private URL addToRegistry(URL location, Manifest manifest) {
        Entry entry = new Entry(location, manifest);
        if (!this.registry.contains(entry)) {
            for (Entry existing : this.registry) {
                if (!existing.getSymbolicName().equals(entry.getSymbolicName())) continue;
                throw new ConflictingModuleException(existing.getSymbolicName(), existing.getVersion(), entry.getVersion());
            }
            this.registry.add(entry);
        }
        return entry.getLocation();
    }

    private URL findInRegistry(BundleSpec spec) {
        URL location = null;
        for (Entry entry : this.registry) {
            if (!spec.isCompatible(entry.getSymbolicName(), entry.getVersion())) continue;
            location = entry.getLocation();
            break;
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Manifest getManifest(URL location) {
        ZipInputStream in = null;
        try {
            in = new JarInputStream(new BufferedInputStream(location.openStream()));
            Manifest manifest = ((JarInputStream)in).getManifest();
            return manifest;
        }
        catch (IOException e) {
            logger.warn("Exception reading " + location, e);
            Manifest manifest = null;
            return manifest;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private String warn(Message message, Object[] arguments) {
        String msg = Resolver.formatMessage(message, arguments);
        logger.warn(msg);
        return msg;
    }

    private static String formatMessage(Message message, Object[] arguments) {
        return MessageFormat.format(resourceBundle.getString(message.key()), arguments);
    }

    static {
        try {
            resourceBundle = ResourceBundle.getBundle(Resolver.class.getName(), Locale.getDefault(), Resolver.class.getClassLoader());
        }
        catch (MissingResourceException mre) {
            throw new RuntimeException("No resource bundle exists for " + Resolver.class.getName());
        }
        catch (Throwable t) {
            throw new RuntimeException("Unexpected error loading resource bundle for " + Resolver.class.getName(), t);
        }
    }

    private static final class Message {
        static final Message WARN_FILE_IGNORED_MISSING_MANIFEST = new Message("warn.file.ignored.missing-manifest");
        static final Message ERROR_BUNDLE_UNREADABLE = new Message("error.bundle.unreadable");
        static final Message ERROR_BUNDLE_UNRESOLVED = new Message("error.bundle.unresolved");
        static final Message ERROR_BUNDLE_DEPENDENCY_UNRESOLVED = new Message("error.bundle-dependency.unresolved");
        private final String resourceBundleKey;

        private Message(String resourceBundleKey) {
            this.resourceBundleKey = resourceBundleKey;
        }

        String key() {
            return this.resourceBundleKey;
        }
    }

    private static class Entry {
        private final URL location;
        private final Manifest manifest;
        private static final int SEED1 = 18181;
        private static final int SEED2 = 181081;

        public Entry(URL location, Manifest manifest) {
            this.location = location;
            this.manifest = manifest;
        }

        public String getVersion() {
            return this.manifest.getMainAttributes().getValue(Resolver.BUNDLE_VERSION);
        }

        public String getSymbolicName() {
            return this.manifest.getMainAttributes().getValue(Resolver.BUNDLE_SYMBOLICNAME);
        }

        public URL getLocation() {
            return this.location;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.location.equals(entry.getLocation()) && this.getVersion().equals(entry.getVersion()) && this.getSymbolicName().equals(entry.getSymbolicName());
        }

        public int hashCode() {
            int result = 18181;
            result = Entry.hash(result, this.location);
            result = Entry.hash(result, this.manifest);
            return result;
        }

        private static int hash(int seed, int value) {
            return 181081 * seed + value;
        }

        private static int hash(int seed, Object object) {
            int result = seed;
            result = object == null ? Entry.hash(result, 0) : Entry.hash(result, object);
            return result;
        }
    }

    private static interface Check {
        public boolean check(URL var1, Manifest var2);
    }
}

