/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bundles;

import java.io.File;

public class OSGiToMaven {
    public static String artifactIdFromSymbolicName(String symbolicName) {
        String last;
        String name = symbolicName;
        do {
            last = name;
        } while (!(name = name.replaceFirst("^[a-zA-Z][0-9a-zA-Z\\-_]*\\.", "")).equals(last) && !name.matches("[0-9\\-_].*"));
        name = last;
        return name;
    }

    public static String groupIdFromSymbolicName(String symbolicName) {
        String name = OSGiToMaven.artifactIdFromSymbolicName(symbolicName);
        int i = symbolicName.lastIndexOf(name);
        return symbolicName.substring(0, i > 0 ? i - 1 : i);
    }

    public static String bundleVersionToProjectVersion(String bundleVersion) {
        String version = bundleVersion.replaceAll("(\\.|-)[a-zA-Z][0-9a-zA-Z\\-_\\.]*$", "");
        String qualifier = bundleVersion.substring(version.length());
        qualifier = qualifier.length() > 0 ? "-" + qualifier.substring(1) : qualifier;
        return version + qualifier;
    }

    public static String makeBundleFilename(String symbolicName, String version) {
        return OSGiToMaven.makeBundleFilename(symbolicName, version, true);
    }

    public static String makeBundleFilename(String name, String version, boolean isSymbolicName) {
        return (isSymbolicName ? OSGiToMaven.artifactIdFromSymbolicName(name) : name) + "-" + OSGiToMaven.bundleVersionToProjectVersion(version) + ".jar";
    }

    public static String makeBundlePathname(String root, String symbolicName, String version) {
        String groupId = OSGiToMaven.groupIdFromSymbolicName(symbolicName);
        String artifactId = OSGiToMaven.artifactIdFromSymbolicName(symbolicName);
        return OSGiToMaven.makeBundlePathname(root, groupId, artifactId, version);
    }

    public static String makeBundlePathname(String root, String groupId, String artifactId, String version) {
        StringBuffer buf = new StringBuffer(root).append('/');
        if (groupId.length() > 0) {
            buf.append(groupId.replace('.', '/')).append('/');
        }
        buf.append(artifactId).append('/');
        buf.append(OSGiToMaven.bundleVersionToProjectVersion(version)).append('/');
        buf.append(OSGiToMaven.makeBundleFilename(artifactId, version, false));
        return buf.toString().replace('/', File.separatorChar);
    }

    public static String makeBundlePathnamePrefix(String root, String groupId, String artifactId) {
        StringBuffer buf = new StringBuffer(root).append('/');
        if (groupId.length() > 0) {
            buf.append(groupId.replace('.', '/')).append('/');
        }
        buf.append(artifactId).append('/');
        return buf.toString().replace('/', File.separatorChar);
    }

    public static String makeFlatBundlePathname(String root, String symbolicName, String version) {
        return OSGiToMaven.makeFlatBundlePathname(root, symbolicName, version, true);
    }

    public static String makeFlatBundlePathname(String root, String name, String version, boolean isSymbolicName) {
        String artifactId = isSymbolicName ? OSGiToMaven.artifactIdFromSymbolicName(name) : name;
        StringBuffer buf = new StringBuffer(root).append('/');
        buf.append(OSGiToMaven.makeBundleFilename(artifactId, version, isSymbolicName));
        return buf.toString().replace('/', File.separatorChar);
    }
}

