/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bundles;

import com.tc.bundles.IConstants;
import com.tc.util.Assert;
import java.util.regex.Matcher;

public class MavenToOSGi
implements IConstants {
    private MavenToOSGi() {
    }

    private static String replaceInvalidChars(String value) {
        return INVALID_OSGI_CHAR_PATTERN.matcher(value).replaceAll("_");
    }

    public static String artifactIdToSymbolicName(String groupId, String artifactId) {
        String name = groupId;
        if (name == null) {
            name = "";
        }
        if (artifactId != null && artifactId.length() > 0) {
            if (name.length() > 0) {
                name = name + ".";
            }
            name = name + artifactId;
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Maven groupId and artifactId are both null or empty, at least one must be defined.");
        }
        return MavenToOSGi.replaceInvalidChars(name);
    }

    public static String projectVersionToBundleVersion(int majorVersion, int minorVersion, int incrementalVersion, String classifier) {
        MavenToOSGi.checkNonNegative(majorVersion, "major version");
        MavenToOSGi.checkNonNegative(minorVersion, "minor version");
        MavenToOSGi.checkNonNegative(minorVersion, "micro version");
        String projectVersion = majorVersion + "." + minorVersion + "." + incrementalVersion;
        if (classifier != null && classifier.length() > 0) {
            return projectVersion + "." + MavenToOSGi.replaceInvalidChars(classifier);
        }
        return projectVersion;
    }

    public static String projectVersionToBundleVersion(String mavenVersion) {
        if (mavenVersion == null) {
            mavenVersion = "";
        }
        int major = 0;
        int minor = 0;
        int micro = 0;
        String classifier = null;
        Matcher matcher = MAVEN_VERSION_PATTERN.matcher(mavenVersion);
        if (matcher.matches()) {
            String majorStr = matcher.group(1);
            String minorStr = matcher.group(2);
            String microStr = matcher.group(3);
            classifier = matcher.group(4);
            major = Integer.parseInt(majorStr);
            if (minorStr != null) {
                minor = Integer.parseInt(minorStr);
            }
            if (microStr != null) {
                micro = Integer.parseInt(microStr);
            }
        } else {
            if (OSGI_VERSION_PATTERN.matcher(mavenVersion).matches()) {
                return mavenVersion;
            }
            classifier = mavenVersion;
        }
        return MavenToOSGi.projectVersionToBundleVersion(major, minor, micro, classifier);
    }

    private static void checkNonNegative(int value, String valueDescription) {
        if (value < 0) {
            Assert.fail("Invalid " + valueDescription + ": " + value + ", must be >= 0");
        }
    }
}

