/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bundles;

import com.tc.bundles.OSGiToMaven;
import com.tc.bundles.Repository;
import com.tc.bundles.ResolverUtils;
import com.tc.logging.TCLogger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSRepository
implements Repository {
    private final File repoFile;
    private final TCLogger logger;

    public FSRepository(File repoFile, TCLogger logger) {
        this.repoFile = repoFile;
        this.logger = logger;
    }

    @Override
    public Collection<URL> search(String groupId, String name, String version) {
        ArrayList<URL> paths = new ArrayList<URL>();
        String root = ResolverUtils.canonicalize(this.repoFile);
        this.addIfValid(paths, OSGiToMaven.makeBundlePathname(root, groupId, name, version));
        this.addIfValid(paths, OSGiToMaven.makeFlatBundlePathname(root, name, version, false));
        return paths;
    }

    private void addIfValid(Collection<URL> paths, String bundle) {
        File f = new File(bundle);
        if (FSRepository.isValid(f)) {
            paths.add(FSRepository.toURL(f));
        }
    }

    private static boolean isValid(File bundle) {
        return bundle.exists() && bundle.isFile();
    }

    private static URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<URL> search(String groupId, String name) {
        String root = ResolverUtils.canonicalize(this.repoFile);
        this.logger.info("root = " + root);
        File repoRoot = new File(root);
        if (!repoRoot.exists() || !repoRoot.isDirectory()) {
            this.logger.info("root directory does not exist");
            return Collections.EMPTY_LIST;
        }
        this.logger.info("looking for possible flat files");
        Collection possibles = FileUtils.listFiles((File)repoRoot, (IOFileFilter)new AndFileFilter((IOFileFilter)new PrefixFileFilter(name + "-"), (IOFileFilter)new SuffixFileFilter(".jar")), null);
        this.logger.info("found flat file possibles = " + possibles.toString());
        File nameRoot = new File(OSGiToMaven.makeBundlePathnamePrefix(root, groupId, name));
        this.logger.info("checking hierarchical repo root: " + nameRoot.getAbsolutePath());
        if (nameRoot.exists() && nameRoot.isDirectory()) {
            possibles.addAll(FileUtils.listFiles((File)nameRoot, (IOFileFilter)new SuffixFileFilter(".jar"), (IOFileFilter)TrueFileFilter.INSTANCE));
            this.logger.info("found all possibles = " + possibles.toString());
        }
        ArrayList<URL> rv = new ArrayList<URL>();
        for (File file : possibles) {
            rv.add(FSRepository.toURL(file));
        }
        return rv;
    }

    @Override
    public String describe() {
        return this.repoFile.getAbsolutePath();
    }
}

