/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bundles;

import com.tc.bundles.OSGiToMaven;
import java.util.Iterator;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyStack
implements Iterable<Object> {
    private final Stack<Object> stack = new Stack();

    public void push(String groupId, String artifactId, String version) {
        StringBuffer buf = new StringBuffer(artifactId);
        buf.append(" version ");
        buf.append(OSGiToMaven.bundleVersionToProjectVersion(version)).append(" (");
        if (groupId.length() > 0) {
            buf.append("group-id: ").append(groupId).append(", ");
        }
        buf.append("file: ").append(OSGiToMaven.makeBundleFilename(artifactId, version, false)).append(")");
        this.stack.push(buf.toString());
    }

    public void push(String symbolicName, String version) {
        this.push(OSGiToMaven.groupIdFromSymbolicName(symbolicName), OSGiToMaven.artifactIdFromSymbolicName(symbolicName), version);
    }

    public int size() {
        return this.stack.size();
    }

    public DependencyStack push(DependencyStack pushed) {
        return (DependencyStack)this.stack.push(pushed);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.stack.iterator();
    }
}

