/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bundles;

import com.tc.bundles.BundleSpec;
import com.tc.bundles.IConstants;
import com.tc.bundles.Version;
import java.util.HashMap;
import java.util.Map;
import org.knopflerfish.framework.VersionRange;

final class BundleSpecImpl
extends BundleSpec {
    private final String symbolicName;
    private final Map attributes = new HashMap();

    BundleSpecImpl(String spec) {
        String[] data = spec.split(";");
        this.symbolicName = data[0];
        for (int i = 1; i < data.length; ++i) {
            String[] pairs = data[i].replaceAll(" ", "").split(":=");
            this.attributes.put(pairs[0], pairs[1].replaceAll("\\\"", ""));
        }
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getName() {
        return this.extractInfo("name");
    }

    public String getGroupId() {
        return this.extractInfo("group-id");
    }

    private String extractInfo(String n) {
        String[] pieces = this.symbolicName.split("\\.");
        int k = 0;
        for (int i = pieces.length - 1; i >= 0; --i) {
            if (!pieces[i].matches("^[a-zA-Z][A-Za-z0-9._\\-]+")) continue;
            k = i;
            break;
        }
        int start = "name".equals(n) ? k : 0;
        int end = "name".equals(n) ? pieces.length : k;
        StringBuffer result = new StringBuffer();
        for (int j = start; j < end; ++j) {
            result.append(pieces[j]).append(".");
        }
        return result.toString().replaceFirst("\\.$", "");
    }

    public String getVersion() {
        return this.isVersionSpecified() ? this.getVersionSpec() : "(any-version)";
    }

    public boolean isOptional() {
        String resolution = (String)this.attributes.get("resolution");
        return resolution != null && resolution.equals("optional");
    }

    public boolean isVersionSpecified() {
        return this.getVersionSpec().length() > 0;
    }

    public boolean isVersionSpecifiedAbsolute() {
        return this.getVersionSpec().matches(IConstants.OSGI_VERSION_PATTERN.pattern());
    }

    private String getVersionSpec() {
        String verspec = (String)this.attributes.get("bundle-version");
        return verspec == null ? "" : verspec;
    }

    public boolean isCompatible(String symName, String version) {
        if (!BundleSpec.isMatchingSymbolicName(this.symbolicName, symName)) {
            return false;
        }
        if (!this.isVersionSpecified()) {
            return true;
        }
        Version target = new Version(version);
        VersionRange range = new VersionRange(this.getVersionSpec());
        return range.withinRange((org.osgi.framework.Version)target);
    }
}

