/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bundles;

import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BundleSpec {
    public static final String REQUIRE_BUNDLE = "Require-Bundle";
    protected static final String PROP_KEY_RESOLUTION = "resolution";
    protected static final String PROP_KEY_BUNDLE_VERSION = "bundle-version";
    protected static final String BUNDLE_SYMBOLIC_NAME_REGEX = "[a-zA-Z][A-Za-z0-9._\\-]+";
    protected static final String REQUIRE_BUNDLE_EXPR_MATCHER = "([a-zA-Z][A-Za-z0-9._\\-]+(;resolution:=\"?optional\"?)?(;bundle-version:=(\"?[A-Za-z0-9.]+\"?|\"?[\\[\\(][A-Za-z0-9.]+,[A-Za-z0-9.]*[\\]\\)]\"?))?)";

    public abstract String getSymbolicName();

    public abstract String getName();

    public abstract String getGroupId();

    public abstract String getVersion();

    public abstract boolean isOptional();

    public abstract boolean isCompatible(String var1, String var2);

    public abstract boolean isVersionSpecified();

    public abstract boolean isVersionSpecifiedAbsolute();

    public static final boolean isMatchingSymbolicName(String arg0, String arg1) {
        return arg0 != null && arg1 != null && arg0.equalsIgnoreCase(arg1);
    }

    public static final String getSymbolicName(Manifest manifest) {
        return manifest.getMainAttributes().getValue("Bundle-SymbolicName");
    }

    public static final String getName(Manifest manifest) {
        return manifest.getMainAttributes().getValue("Bundle-Name");
    }

    public static final String getVersion(Manifest manifest) {
        return manifest.getMainAttributes().getValue("Bundle-Version");
    }

    public static final String getDescription(Manifest manifest) {
        return manifest.getMainAttributes().getValue("Bundle-Description");
    }

    public static final String[] getRequirements(Manifest manifest) {
        return BundleSpec.getRequirements(manifest.getMainAttributes().getValue(REQUIRE_BUNDLE));
    }

    public static final String[] getRequirements(String requiredBundles) {
        if (requiredBundles == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        String spec = requiredBundles.replaceAll(" ", "");
        Pattern pattern = Pattern.compile(REQUIRE_BUNDLE_EXPR_MATCHER);
        Matcher matcher = pattern.matcher(spec);
        StringBuffer check = new StringBuffer();
        while (matcher.find()) {
            String group = matcher.group();
            check.append("," + group);
            list.add(group);
        }
        if (!spec.equals(check.toString().replaceFirst(",", ""))) {
            String arg0 = "Syntax error specifying the required bundle list in the manifest: ''{0}'' found ''{1}''";
            Object[] arg1 = new Object[]{requiredBundles, check};
            throw new RuntimeException(MessageFormat.format("Syntax error specifying the required bundle list in the manifest: ''{0}'' found ''{1}''", arg1));
        }
        return list.toArray(new String[list.size()]);
    }

    public static final BundleSpec newInstance(String spec) {
        String BUNDLESPECIMPL = "com.tc.bundles.BundleSpecImpl";
        try {
            Class<?> klass = Class.forName("com.tc.bundles.BundleSpecImpl");
            Constructor<?> constructor = klass.getDeclaredConstructor(String.class);
            return (BundleSpec)constructor.newInstance(spec);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create an instance of class com.tc.bundles.BundleSpecImpl", e);
        }
    }
}

