/*
 * Decompiled with CFR 0.152.
 */
package com.tc.backport175;

import com.tc.backport175.Annotation;
import com.tc.backport175.bytecode.AnnotationReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;

public final class Annotations {
    public static boolean isAnnotationPresent(Class annotationType, Class target) {
        boolean isPresent = AnnotationReader.getReaderFor(target).isAnnotationPresent(Annotations.getAnnnotationName(annotationType));
        if (!isPresent && Annotations.isInherited(annotationType)) {
            if (target.getSuperclass() == null) {
                return isPresent;
            }
            return Annotations.isAnnotationPresent(annotationType, target.getSuperclass());
        }
        return isPresent;
    }

    public static Annotation[] getAnnotations(Class target) {
        int i;
        Annotation[] declaredAnnotations = AnnotationReader.getReaderFor(target).getAnnotations();
        if (target.getSuperclass() == null) {
            return declaredAnnotations;
        }
        ArrayList<Annotation> annotations = new ArrayList<Annotation>(declaredAnnotations.length);
        Annotation[] parents = Annotations.getAnnotations(target.getSuperclass());
        for (i = 0; i < parents.length; ++i) {
            if (!Annotations.isInherited(parents[i].annotationType())) continue;
            annotations.add(parents[i]);
        }
        for (i = 0; i < declaredAnnotations.length; ++i) {
            annotations.add(declaredAnnotations[i]);
        }
        return annotations.toArray(new Annotation[0]);
    }

    public static Annotation getAnnotation(Class annotationType, Class target) {
        AnnotationReader reader = AnnotationReader.getReaderFor(target);
        Annotation annotation = reader.getAnnotation(Annotations.getAnnnotationName(annotationType));
        if (annotation == null && Annotations.isInherited(annotationType)) {
            if (target.getSuperclass() == null) {
                return annotation;
            }
            return Annotations.getAnnotation(annotationType, target.getSuperclass());
        }
        return annotation;
    }

    public static boolean isAnnotationPresent(Class annotationType, Method method) {
        AnnotationReader reader = AnnotationReader.getReaderFor(method.getDeclaringClass());
        return reader.isAnnotationPresent(Annotations.getAnnnotationName(annotationType), method);
    }

    public static Annotation[] getAnnotations(Method method) {
        return AnnotationReader.getReaderFor(method.getDeclaringClass()).getAnnotations(method);
    }

    public static Annotation getAnnotation(Class annotationType, Method method) {
        AnnotationReader reader = AnnotationReader.getReaderFor(method.getDeclaringClass());
        return reader.getAnnotation(Annotations.getAnnnotationName(annotationType), method);
    }

    public static boolean isAnnotationPresent(Class annotationType, Constructor constructor) {
        AnnotationReader reader = AnnotationReader.getReaderFor(constructor.getDeclaringClass());
        return reader.isAnnotationPresent(Annotations.getAnnnotationName(annotationType), constructor);
    }

    public static Annotation[] getAnnotations(Constructor constructor) {
        return AnnotationReader.getReaderFor(constructor.getDeclaringClass()).getAnnotations(constructor);
    }

    public static Annotation getAnnotation(Class annotationType, Constructor constructor) {
        AnnotationReader reader = AnnotationReader.getReaderFor(constructor.getDeclaringClass());
        return reader.getAnnotation(Annotations.getAnnnotationName(annotationType), constructor);
    }

    public static boolean isAnnotationPresent(Class annotationType, Field field) {
        AnnotationReader reader = AnnotationReader.getReaderFor(field.getDeclaringClass());
        return reader.isAnnotationPresent(Annotations.getAnnnotationName(annotationType), field);
    }

    public static Annotation[] getAnnotations(Field field) {
        return AnnotationReader.getReaderFor(field.getDeclaringClass()).getAnnotations(field);
    }

    public static Annotation getAnnotation(Class annotationType, Field field) {
        AnnotationReader reader = AnnotationReader.getReaderFor(field.getDeclaringClass());
        return reader.getAnnotation(Annotations.getAnnnotationName(annotationType), field);
    }

    private static String getAnnnotationName(Class annotationType) {
        return annotationType.getName().replace('/', '.');
    }

    private static boolean isInherited(Class annotationType) {
        return AnnotationReader.getReaderFor(annotationType).isAnnotationPresent("java.lang.annotation.Inherited");
    }
}

