/*
 * Decompiled with CFR 0.152.
 */
package com.tc.asm.optimizer;

import com.tc.asm.AnnotationVisitor;
import com.tc.asm.Label;
import com.tc.asm.MethodAdapter;
import com.tc.asm.MethodVisitor;
import com.tc.asm.optimizer.AnnotationConstantsCollector;
import com.tc.asm.optimizer.ConstantPool;

public class MethodConstantsCollector
extends MethodAdapter {
    private final ConstantPool cp;

    public MethodConstantsCollector(MethodVisitor mv, ConstantPool cp) {
        super(mv);
        this.cp = cp;
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.cp.newUTF8("AnnotationDefault");
        return new AnnotationConstantsCollector(this.mv.visitAnnotationDefault(), this.cp);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.cp.newUTF8(desc);
        if (visible) {
            this.cp.newUTF8("RuntimeVisibleAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleAnnotations");
        }
        return new AnnotationConstantsCollector(this.mv.visitAnnotation(desc, visible), this.cp);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        this.cp.newUTF8(desc);
        if (visible) {
            this.cp.newUTF8("RuntimeVisibleParameterAnnotations");
        } else {
            this.cp.newUTF8("RuntimeInvisibleParameterAnnotations");
        }
        return new AnnotationConstantsCollector(this.mv.visitParameterAnnotation(parameter, desc, visible), this.cp);
    }

    public void visitTypeInsn(int opcode, String type) {
        this.cp.newClass(type);
        this.mv.visitTypeInsn(opcode, type);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.cp.newField(owner, name, desc);
        this.mv.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        boolean itf = opcode == 185;
        this.cp.newMethod(owner, name, desc, itf);
        this.mv.visitMethodInsn(opcode, owner, name, desc);
    }

    public void visitLdcInsn(Object cst) {
        this.cp.newConst(cst);
        this.mv.visitLdcInsn(cst);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.cp.newClass(desc);
        this.mv.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (type != null) {
            this.cp.newClass(type);
        }
        this.mv.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (signature != null) {
            this.cp.newUTF8("LocalVariableTypeTable");
            this.cp.newUTF8(name);
            this.cp.newUTF8(signature);
        }
        this.cp.newUTF8("LocalVariableTable");
        this.cp.newUTF8(name);
        this.cp.newUTF8(desc);
        this.mv.visitLocalVariable(name, desc, signature, start, end, index);
    }

    public void visitLineNumber(int line, Label start) {
        this.cp.newUTF8("LineNumberTable");
        this.mv.visitLineNumber(line, start);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.cp.newUTF8("Code");
        this.mv.visitMaxs(maxStack, maxLocals);
    }
}

