/*
 * Decompiled with CFR 0.152.
 */
package com.tc.asm.commons;

import com.tc.asm.AnnotationVisitor;
import com.tc.asm.Label;
import com.tc.asm.MethodVisitor;
import com.tc.asm.commons.LocalVariablesSorter;
import com.tc.asm.commons.Remapper;
import com.tc.asm.commons.RemappingAnnotationAdapter;

public class RemappingMethodAdapter
extends LocalVariablesSorter {
    protected final Remapper remapper;

    public RemappingMethodAdapter(int access, String desc, MethodVisitor mv, Remapper renamer) {
        super(access, desc, mv);
        this.remapper = renamer;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        super.visitFieldInsn(opcode, this.remapper.mapType(owner), this.remapper.mapFieldName(owner, name, desc), this.remapper.mapDesc(desc));
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        super.visitMethodInsn(opcode, this.remapper.mapType(owner), this.remapper.mapMethodName(owner, name, desc), this.remapper.mapMethodDesc(desc));
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, this.remapper.mapType(type));
    }

    public void visitLdcInsn(Object cst) {
        super.visitLdcInsn(this.remapper.mapValue(cst));
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        super.visitMultiANewArrayInsn(this.remapper.mapDesc(desc), dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        super.visitTryCatchBlock(start, end, handler, type == null ? null : this.remapper.mapType(type));
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        super.visitLocalVariable(name, this.remapper.mapDesc(desc), this.remapper.mapSignature(signature, true), start, end, index);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = this.mv.visitAnnotation(desc, visible);
        return av == null ? av : new RemappingAnnotationAdapter(av, this.remapper);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        AnnotationVisitor av = this.mv.visitAnnotationDefault();
        return av == null ? av : new RemappingAnnotationAdapter(av, this.remapper);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        AnnotationVisitor av = this.mv.visitParameterAnnotation(parameter, desc, visible);
        return av == null ? av : new RemappingAnnotationAdapter(av, this.remapper);
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        super.visitFrame(type, nLocal, this.remapEntries(nLocal, local), nStack, this.remapEntries(nStack, stack));
    }

    private Object[] remapEntries(int n, Object[] entries) {
        for (int i = 0; i < n; ++i) {
            if (!(entries[i] instanceof String)) continue;
            Object[] newEntries = new Object[n];
            if (i > 0) {
                System.arraycopy(entries, 0, newEntries, 0, i);
            }
            do {
                Object t = entries[i];
                Object object = newEntries[i++] = t instanceof String ? this.remapper.mapType((String)t) : t;
            } while (i < n);
            return newEntries;
        }
        return entries;
    }
}

