/*
 * Decompiled with CFR 0.152.
 */
package com.tc.backport175.bytecode;

import com.tc.asm.AnnotationVisitor;
import com.tc.asm.ClassReader;
import com.tc.asm.MethodVisitor;
import com.tc.asm.commons.EmptyVisitor;
import com.tc.backport175.ReaderException;
import com.tc.backport175.bytecode.AnnotationElement;
import com.tc.backport175.bytecode.AnnotationReader;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;

class AnnotationDefaults {
    private static Map s_annotationDefaults = new WeakHashMap();

    AnnotationDefaults() {
    }

    public static AnnotationElement.Annotation getDefaults(String annotationClassName, ClassLoader loader) {
        AnnotationReader.ClassKey key = new AnnotationReader.ClassKey(annotationClassName, loader);
        AnnotationElement.Annotation defaults = (AnnotationElement.Annotation)s_annotationDefaults.get(key);
        if (defaults == null) {
            byte[] bytes;
            AnnotationElement.Annotation newDefaults = new AnnotationElement.Annotation(annotationClassName);
            try {
                bytes = AnnotationReader.getBytecodeFor(annotationClassName, loader);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ReaderException("could not retrieve the bytecode from the bytecode provider for class [" + annotationClassName + "]", e);
            }
            ClassReader cr = new ClassReader(bytes);
            cr.accept(new AnnotationDefaultsClassVisitor(newDefaults, loader), 7);
            defaults = newDefaults;
            s_annotationDefaults.put(key, newDefaults);
        }
        return defaults;
    }

    public static void refresh(AnnotationReader.ClassKey key) {
        AnnotationElement.Annotation defaults = (AnnotationElement.Annotation)s_annotationDefaults.get(key);
        if (defaults != null) {
            s_annotationDefaults.remove(key);
        }
    }

    static class DefaultAnnotationBuilderVisitor
    extends AnnotationReader.AnnotationBuilderVisitor {
        private String m_methodName;

        DefaultAnnotationBuilderVisitor(AnnotationElement.NestedAnnotationElement annotation, String methodName, ClassLoader loader) {
            super(annotation, loader, null);
            this.m_methodName = methodName;
        }

        public void visit(String name, Object value) {
            super.visit(this.m_methodName, value);
        }

        public void visitEnum(String name, String desc, String value) {
            super.visitEnum(this.m_methodName, desc, value);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return super.visitAnnotation(this.m_methodName, desc);
        }

        public AnnotationVisitor visitArray(String name) {
            return super.visitArray(this.m_methodName);
        }
    }

    static final class AnnotationDefaultsMethodVisitor
    extends EmptyVisitor {
        private final String name;
        private final AnnotationElement.Annotation defaults;
        private final ClassLoader loader;

        AnnotationDefaultsMethodVisitor(String name, AnnotationElement.Annotation defaults, ClassLoader loader) {
            this.name = name;
            this.defaults = defaults;
            this.loader = loader;
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return new DefaultAnnotationBuilderVisitor((AnnotationElement.NestedAnnotationElement)this.defaults, this.name, this.loader);
        }
    }

    static final class AnnotationDefaultsClassVisitor
    extends EmptyVisitor {
        private final AnnotationElement.Annotation defaults;
        private final ClassLoader loader;

        AnnotationDefaultsClassVisitor(AnnotationElement.Annotation defaults, ClassLoader loader) {
            this.defaults = defaults;
            this.loader = loader;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new AnnotationDefaultsMethodVisitor(name, this.defaults, this.loader);
        }
    }
}

