/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.InterpreterApi;
import org.tensorflow.lite.NativeInterpreterWrapper;
import org.tensorflow.lite.Tensor;

public final class Interpreter
implements InterpreterApi {
    NativeInterpreterWrapper wrapper;
    String[] signatureNameList;

    public Interpreter(@NonNull File modelFile) {
        this(modelFile, null);
    }

    public Interpreter(@NonNull File modelFile, Options options) {
        this.wrapper = new NativeInterpreterWrapper(modelFile.getAbsolutePath(), options);
        this.signatureNameList = this.getSignatureDefNames();
    }

    public Interpreter(@NonNull ByteBuffer byteBuffer) {
        this(byteBuffer, null);
    }

    public Interpreter(@NonNull ByteBuffer byteBuffer, Options options) {
        this.wrapper = new NativeInterpreterWrapper(byteBuffer, options);
        this.signatureNameList = this.getSignatureDefNames();
    }

    @Override
    public void run(Object input, Object output) {
        Object[] inputs = new Object[]{input};
        HashMap<Integer, Object> outputs = new HashMap<Integer, Object>();
        outputs.put(0, output);
        this.runForMultipleInputsOutputs(inputs, outputs);
    }

    @Override
    public void runForMultipleInputsOutputs(@NonNull Object[] inputs, @NonNull Map<Integer, Object> outputs) {
        this.checkNotClosed();
        this.wrapper.run(inputs, outputs);
    }

    public void runSignature(@NonNull Map<String, Object> inputs, @NonNull Map<String, Object> outputs, String methodName) {
        this.checkNotClosed();
        if (methodName == null && this.signatureNameList.length == 1) {
            methodName = this.signatureNameList[0];
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Input error: SignatureDef methodName should not be null. null is only allowed if the model has a single Signature. Available Signatures: " + Arrays.toString(this.signatureNameList));
        }
        this.wrapper.runSignature(inputs, outputs, methodName);
    }

    public void runSignature(@NonNull Map<String, Object> inputs, @NonNull Map<String, Object> outputs) {
        this.checkNotClosed();
        this.runSignature(inputs, outputs, null);
    }

    @Override
    public void allocateTensors() {
        this.checkNotClosed();
        this.wrapper.allocateTensors();
    }

    @Override
    public void resizeInput(int idx, @NonNull int[] dims) {
        this.checkNotClosed();
        this.wrapper.resizeInput(idx, dims, false);
    }

    @Override
    public void resizeInput(int idx, @NonNull int[] dims, boolean strict) {
        this.checkNotClosed();
        this.wrapper.resizeInput(idx, dims, strict);
    }

    @Override
    public int getInputTensorCount() {
        this.checkNotClosed();
        return this.wrapper.getInputTensorCount();
    }

    @Override
    public int getInputIndex(String opName) {
        this.checkNotClosed();
        return this.wrapper.getInputIndex(opName);
    }

    @Override
    public Tensor getInputTensor(int inputIndex) {
        this.checkNotClosed();
        return this.wrapper.getInputTensor(inputIndex);
    }

    public Tensor getInputTensorFromSignature(String inputName, String methodName) {
        this.checkNotClosed();
        if (methodName == null && this.signatureNameList.length == 1) {
            methodName = this.signatureNameList[0];
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Input error: SignatureDef methodName should not be null. null is only allowed if the model has a single Signature. Available Signatures: " + Arrays.toString(this.signatureNameList));
        }
        return this.wrapper.getInputTensor(inputName, methodName);
    }

    public String[] getSignatureDefNames() {
        this.checkNotClosed();
        return this.wrapper.getSignatureDefNames();
    }

    public String[] getSignatureInputs(String methodName) {
        this.checkNotClosed();
        return this.wrapper.getSignatureInputs(methodName);
    }

    public String[] getSignatureOutputs(String methodName) {
        this.checkNotClosed();
        return this.wrapper.getSignatureOutputs(methodName);
    }

    @Override
    public int getOutputTensorCount() {
        this.checkNotClosed();
        return this.wrapper.getOutputTensorCount();
    }

    @Override
    public int getOutputIndex(String opName) {
        this.checkNotClosed();
        return this.wrapper.getOutputIndex(opName);
    }

    @Override
    public Tensor getOutputTensor(int outputIndex) {
        this.checkNotClosed();
        return this.wrapper.getOutputTensor(outputIndex);
    }

    public Tensor getOutputTensorFromSignature(String outputName, String methodName) {
        this.checkNotClosed();
        if (methodName == null && this.signatureNameList.length == 1) {
            methodName = this.signatureNameList[0];
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Input error: SignatureDef methodName should not be null. null is only allowed if the model has a single Signature. Available Signatures: " + Arrays.toString(this.signatureNameList));
        }
        return this.wrapper.getOutputTensor(outputName, methodName);
    }

    @Override
    public Long getLastNativeInferenceDurationNanoseconds() {
        this.checkNotClosed();
        return this.wrapper.getLastNativeInferenceDurationNanoseconds();
    }

    public void resetVariableTensors() {
        this.checkNotClosed();
        this.wrapper.resetVariableTensors();
    }

    public void setCancelled(boolean cancelled) {
        this.wrapper.setCancelled(cancelled);
    }

    int getExecutionPlanLength() {
        this.checkNotClosed();
        return this.wrapper.getExecutionPlanLength();
    }

    @Override
    public void close() {
        if (this.wrapper != null) {
            this.wrapper.close();
            this.wrapper = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void checkNotClosed() {
        if (this.wrapper == null) {
            throw new IllegalStateException("Internal error: The Interpreter has already been closed.");
        }
    }

    public static class Options
    extends InterpreterApi.Options {
        Boolean allowFp16PrecisionForFp32;
        Boolean allowBufferHandleOutput;
        Boolean useXNNPACK;
        final List<Delegate> delegates = new ArrayList<Delegate>();

        @Override
        public Options setNumThreads(int numThreads) {
            super.setNumThreads(numThreads);
            return this;
        }

        @Override
        public Options setUseNNAPI(boolean useNNAPI) {
            super.setUseNNAPI(useNNAPI);
            return this;
        }

        @Deprecated
        public Options setAllowFp16PrecisionForFp32(boolean allow) {
            this.allowFp16PrecisionForFp32 = allow;
            return this;
        }

        public Options addDelegate(Delegate delegate) {
            this.delegates.add(delegate);
            return this;
        }

        public Options setAllowBufferHandleOutput(boolean allow) {
            this.allowBufferHandleOutput = allow;
            return this;
        }

        @Override
        public Options setCancellable(boolean allow) {
            super.setCancellable(allow);
            return this;
        }

        public Options setUseXNNPACK(boolean useXNNPACK) {
            this.useXNNPACK = useXNNPACK;
            return this;
        }
    }
}

