/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.nnapi;

import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.TensorFlowLite;

public class NnApiDelegate
implements Delegate,
AutoCloseable {
    private static final long INVALID_DELEGATE_HANDLE = 0L;
    private long delegateHandle;

    public NnApiDelegate(Options options) {
        TensorFlowLite.init();
        this.delegateHandle = NnApiDelegate.createDelegate(options.executionPreference, options.accelerator_name, options.cache_dir, options.model_token);
    }

    public NnApiDelegate() {
        this(new Options());
    }

    @Override
    public long getNativeHandle() {
        return this.delegateHandle;
    }

    @Override
    public void close() {
        if (this.delegateHandle != 0L) {
            NnApiDelegate.deleteDelegate(this.delegateHandle);
            this.delegateHandle = 0L;
        }
    }

    private static native long createDelegate(int var0, String var1, String var2, String var3);

    private static native void deleteDelegate(long var0);

    public static final class Options {
        public static final int EXECUTION_PREFERENCE_UNDEFINED = -1;
        public static final int EXECUTION_PREFERENCE_LOW_POWER = 0;
        public static final int EXECUTION_PREFERENCE_FAST_SINGLE_ANSWER = 1;
        public static final int EXECUTION_PREFERENCE_SUSTAINED_SPEED = 2;
        int executionPreference = -1;
        String accelerator_name = null;
        String cache_dir = null;
        String model_token = null;

        public Options setExecutionPreference(int preference) {
            this.executionPreference = preference;
            return this;
        }

        public Options setAcceleratorName(String name) {
            this.accelerator_name = name;
            return this;
        }

        public Options setCacheDir(String name) {
            this.cache_dir = name;
            return this;
        }

        public Options setModelToken(String name) {
            this.model_token = name;
            return this;
        }
    }
}

