/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite;

import org.tensorflow.lite.TensorFlowLite;

enum DataType {
    FLOAT32(1),
    INT32(2),
    UINT8(3),
    INT64(4),
    BYTEBUFFER(999);

    private final int value;
    private static final DataType[] values;

    private DataType(int value) {
        this.value = value;
    }

    int getNumber() {
        return this.value;
    }

    static DataType fromNumber(int c) {
        for (DataType t : values) {
            if (t.value != c) continue;
            return t;
        }
        String string = TensorFlowLite.version();
        throw new IllegalArgumentException(new StringBuilder(57 + String.valueOf(string).length()).append("DataType ").append(c).append(" is not recognized in Java (version ").append(string).append(")").toString());
    }

    int elemByteSize() {
        switch (this) {
            case FLOAT32: {
                return 4;
            }
            case INT32: {
                return 4;
            }
            case UINT8: {
                return 1;
            }
            case INT64: {
                return 8;
            }
            case BYTEBUFFER: {
                return 1;
            }
        }
        String string = String.valueOf((Object)this);
        throw new IllegalArgumentException(new StringBuilder(30 + String.valueOf(string).length()).append("DataType ").append(string).append(" is not supported yet").toString());
    }

    static {
        values = DataType.values();
    }
}

