/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.vision.segmenter;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.os.ParcelFileDescriptor;
import com.google.auto.value.AutoValue;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.support.image.TensorImage;
import org.tensorflow.lite.task.core.BaseTaskApi;
import org.tensorflow.lite.task.core.TaskJniUtils;
import org.tensorflow.lite.task.core.vision.ImageProcessingOptions;
import org.tensorflow.lite.task.vision.segmenter.AutoValue_ImageSegmenter_ImageSegmenterOptions;
import org.tensorflow.lite.task.vision.segmenter.ColoredLabel;
import org.tensorflow.lite.task.vision.segmenter.OutputType;
import org.tensorflow.lite.task.vision.segmenter.Segmentation;

public final class ImageSegmenter
extends BaseTaskApi {
    private static final String IMAGE_SEGMENTER_NATIVE_LIB = "task_vision_jni";
    private static final int OPTIONAL_FD_LENGTH = -1;
    private static final int OPTIONAL_FD_OFFSET = -1;
    private final OutputType outputType;

    public static ImageSegmenter createFromFile(Context context, String modelPath) throws IOException {
        return ImageSegmenter.createFromFileAndOptions(context, modelPath, ImageSegmenterOptions.builder().build());
    }

    public static ImageSegmenter createFromFile(File modelFile) throws IOException {
        return ImageSegmenter.createFromFileAndOptions(modelFile, ImageSegmenterOptions.builder().build());
    }

    public static ImageSegmenter createFromBuffer(ByteBuffer modelBuffer) {
        return ImageSegmenter.createFromBufferAndOptions(modelBuffer, ImageSegmenterOptions.builder().build());
    }

    public static ImageSegmenter createFromFileAndOptions(Context context, String modelPath, ImageSegmenterOptions options) throws IOException {
        try (AssetFileDescriptor assetFileDescriptor = context.getAssets().openFd(modelPath);){
            ImageSegmenter imageSegmenter = ImageSegmenter.createFromModelFdAndOptions(assetFileDescriptor.getParcelFileDescriptor().getFd(), assetFileDescriptor.getLength(), assetFileDescriptor.getStartOffset(), options);
            return imageSegmenter;
        }
    }

    public static ImageSegmenter createFromFileAndOptions(File modelFile, ImageSegmenterOptions options) throws IOException {
        try (ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)modelFile, (int)0x10000000);){
            ImageSegmenter imageSegmenter = ImageSegmenter.createFromModelFdAndOptions(descriptor.getFd(), -1L, -1L, options);
            return imageSegmenter;
        }
    }

    public static ImageSegmenter createFromBufferAndOptions(final ByteBuffer modelBuffer, final ImageSegmenterOptions options) {
        if (!modelBuffer.isDirect() && !(modelBuffer instanceof MappedByteBuffer)) {
            throw new IllegalArgumentException("The model buffer should be either a direct ByteBuffer or a MappedByteBuffer.");
        }
        return new ImageSegmenter(TaskJniUtils.createHandleFromLibrary((TaskJniUtils.EmptyHandleProvider)new TaskJniUtils.EmptyHandleProvider(){

            public long createHandle() {
                return ImageSegmenter.initJniWithByteBuffer(modelBuffer, options.getDisplayNamesLocale(), options.getOutputType().getValue(), options.getNumThreads());
            }
        }, (String)IMAGE_SEGMENTER_NATIVE_LIB), options.getOutputType());
    }

    private ImageSegmenter(long nativeHandle, OutputType outputType) {
        super(nativeHandle);
        this.outputType = outputType;
    }

    public List<Segmentation> segment(TensorImage image) {
        return this.segment(image, ImageProcessingOptions.builder().build());
    }

    public List<Segmentation> segment(TensorImage image, ImageProcessingOptions options) {
        this.checkNotClosed();
        TensorImage imageUint8 = image.getDataType() == DataType.UINT8 ? image : TensorImage.createFrom((TensorImage)image, (DataType)DataType.UINT8);
        ArrayList<byte[]> maskByteArrays = new ArrayList<byte[]>();
        ArrayList<ColoredLabel> coloredLabels = new ArrayList<ColoredLabel>();
        int[] maskShape = new int[2];
        ImageSegmenter.segmentNative(this.getNativeHandle(), imageUint8.getBuffer(), imageUint8.getWidth(), imageUint8.getHeight(), maskByteArrays, maskShape, coloredLabels, options.getOrientation().getValue());
        ArrayList<ByteBuffer> maskByteBuffers = new ArrayList<ByteBuffer>();
        for (byte[] bytes : maskByteArrays) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            maskByteBuffers.add(byteBuffer);
        }
        return Arrays.asList(Segmentation.create(this.outputType, this.outputType.createMasksFromBuffer(maskByteBuffers, maskShape), coloredLabels));
    }

    private static ImageSegmenter createFromModelFdAndOptions(final int fileDescriptor, final long fileDescriptorLength, final long fileDescriptorOffset, final ImageSegmenterOptions options) {
        long nativeHandle = TaskJniUtils.createHandleFromLibrary((TaskJniUtils.EmptyHandleProvider)new TaskJniUtils.EmptyHandleProvider(){

            public long createHandle() {
                return ImageSegmenter.initJniWithModelFdAndOptions(fileDescriptor, fileDescriptorLength, fileDescriptorOffset, options.getDisplayNamesLocale(), options.getOutputType().getValue(), options.getNumThreads());
            }
        }, (String)IMAGE_SEGMENTER_NATIVE_LIB);
        return new ImageSegmenter(nativeHandle, options.getOutputType());
    }

    private static native long initJniWithModelFdAndOptions(int var0, long var1, long var3, String var5, int var6, int var7);

    private static native long initJniWithByteBuffer(ByteBuffer var0, String var1, int var2, int var3);

    private static native void segmentNative(long var0, ByteBuffer var2, int var3, int var4, List<byte[]> var5, int[] var6, List<ColoredLabel> var7, int var8);

    protected void deinit(long nativeHandle) {
        this.deinitJni(nativeHandle);
    }

    private native void deinitJni(long var1);

    @AutoValue
    public static abstract class ImageSegmenterOptions {
        private static final String DEFAULT_DISPLAY_NAME_LOCALE = "en";
        private static final OutputType DEFAULT_OUTPUT_TYPE = OutputType.CATEGORY_MASK;
        private static final int NUM_THREADS = -1;

        public abstract String getDisplayNamesLocale();

        public abstract OutputType getOutputType();

        public abstract int getNumThreads();

        public static Builder builder() {
            return new AutoValue_ImageSegmenter_ImageSegmenterOptions.Builder().setDisplayNamesLocale(DEFAULT_DISPLAY_NAME_LOCALE).setOutputType(DEFAULT_OUTPUT_TYPE).setNumThreads(-1);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setDisplayNamesLocale(String var1);

            public abstract Builder setOutputType(OutputType var1);

            public abstract Builder setNumThreads(int var1);

            public abstract ImageSegmenterOptions build();
        }
    }
}

