/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.vision.segmenter;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.support.image.TensorImage;
import org.tensorflow.lite.task.core.BaseTaskApi;
import org.tensorflow.lite.task.core.TaskJniUtils;
import org.tensorflow.lite.task.core.vision.ImageProcessingOptions;
import org.tensorflow.lite.task.vision.segmenter.AutoValue_ImageSegmenter_ImageSegmenterOptions;
import org.tensorflow.lite.task.vision.segmenter.ColoredLabel;
import org.tensorflow.lite.task.vision.segmenter.OutputType;
import org.tensorflow.lite.task.vision.segmenter.Segmentation;

public final class ImageSegmenter
extends BaseTaskApi {
    private static final String IMAGE_SEGMENTER_NATIVE_LIB = "task_vision_jni";
    private final OutputType outputType;

    public static ImageSegmenter createFromFile(Context context, String modelPath) throws IOException {
        return ImageSegmenter.createFromFileAndOptions(context, modelPath, ImageSegmenterOptions.builder().build());
    }

    public static ImageSegmenter createFromFileAndOptions(Context context, String modelPath, final ImageSegmenterOptions options) throws IOException {
        try (final AssetFileDescriptor assetFileDescriptor = context.getAssets().openFd(modelPath);){
            long nativeHandle = TaskJniUtils.createHandleFromLibrary((TaskJniUtils.EmptyHandleProvider)new TaskJniUtils.EmptyHandleProvider(){

                public long createHandle() {
                    return ImageSegmenter.initJniWithModelFdAndOptions(assetFileDescriptor.getParcelFileDescriptor().getFd(), assetFileDescriptor.getLength(), assetFileDescriptor.getStartOffset(), options.getDisplayNamesLocale(), options.getOutputType().getValue());
                }
            }, (String)IMAGE_SEGMENTER_NATIVE_LIB);
            ImageSegmenter imageSegmenter = new ImageSegmenter(nativeHandle, options.getOutputType());
            return imageSegmenter;
        }
    }

    private ImageSegmenter(long nativeHandle, OutputType outputType) {
        super(nativeHandle);
        this.outputType = outputType;
    }

    public List<Segmentation> segment(TensorImage image) {
        return this.segment(image, ImageProcessingOptions.builder().build());
    }

    public List<Segmentation> segment(TensorImage image, ImageProcessingOptions options) {
        this.checkNotClosed();
        TensorImage imageUint8 = image.getDataType() == DataType.UINT8 ? image : TensorImage.createFrom((TensorImage)image, (DataType)DataType.UINT8);
        ArrayList<byte[]> maskByteArrays = new ArrayList<byte[]>();
        ArrayList<ColoredLabel> coloredLabels = new ArrayList<ColoredLabel>();
        int[] maskShape = new int[2];
        ImageSegmenter.segmentNative(this.getNativeHandle(), imageUint8.getBuffer(), imageUint8.getWidth(), imageUint8.getHeight(), maskByteArrays, maskShape, coloredLabels, options.getOrientation().getValue());
        ArrayList<ByteBuffer> maskByteBuffers = new ArrayList<ByteBuffer>();
        for (byte[] bytes : maskByteArrays) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            maskByteBuffers.add(byteBuffer);
        }
        return Arrays.asList(Segmentation.create(this.outputType, this.outputType.createMasksFromBuffer(maskByteBuffers, maskShape), coloredLabels));
    }

    private static native long initJniWithModelFdAndOptions(int var0, long var1, long var3, String var5, int var6);

    private static native void segmentNative(long var0, ByteBuffer var2, int var3, int var4, List<byte[]> var5, int[] var6, List<ColoredLabel> var7, int var8);

    protected void deinit(long nativeHandle) {
        this.deinitJni(nativeHandle);
    }

    private native void deinitJni(long var1);

    @AutoValue
    public static abstract class ImageSegmenterOptions {
        private static final String DEFAULT_DISPLAY_NAME_LOCALE = "en";
        private static final OutputType DEFAULT_OUTPUT_TYPE = OutputType.CATEGORY_MASK;

        public abstract String getDisplayNamesLocale();

        public abstract OutputType getOutputType();

        public static Builder builder() {
            return new AutoValue_ImageSegmenter_ImageSegmenterOptions.Builder().setDisplayNamesLocale(DEFAULT_DISPLAY_NAME_LOCALE).setOutputType(DEFAULT_OUTPUT_TYPE);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setDisplayNamesLocale(String var1);

            public abstract Builder setOutputType(OutputType var1);

            public abstract ImageSegmenterOptions build();
        }
    }
}

