/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.vision.detector;

import android.content.Context;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.annotations.UsedByReflection;
import org.tensorflow.lite.support.image.TensorImage;
import org.tensorflow.lite.task.core.BaseTaskApi;
import org.tensorflow.lite.task.core.TaskJniUtils;
import org.tensorflow.lite.task.core.vision.ImageProcessingOptions;
import org.tensorflow.lite.task.vision.detector.Detection;

public final class ObjectDetector
extends BaseTaskApi {
    private static final String OBJECT_DETECTOR_NATIVE_LIB = "task_vision_jni";

    public static ObjectDetector createFromFile(Context context, String modelPath) throws IOException {
        return ObjectDetector.createFromFileAndOptions(context, modelPath, ObjectDetectorOptions.builder().build());
    }

    public static ObjectDetector createFromFileAndOptions(Context context, String modelPath, ObjectDetectorOptions options) throws IOException {
        return new ObjectDetector(TaskJniUtils.createHandleFromFdAndOptions((Context)context, (TaskJniUtils.FdAndOptionsHandleProvider)new TaskJniUtils.FdAndOptionsHandleProvider<ObjectDetectorOptions>(){

            public long createHandle(int fileDescriptor, long fileDescriptorLength, long fileDescriptorOffset, ObjectDetectorOptions options) {
                return ObjectDetector.initJniWithModelFdAndOptions(fileDescriptor, fileDescriptorLength, fileDescriptorOffset, options);
            }
        }, (String)OBJECT_DETECTOR_NATIVE_LIB, (String)modelPath, (Object)options));
    }

    private ObjectDetector(long nativeHandle) {
        super(nativeHandle);
    }

    public List<Detection> detect(TensorImage image) {
        return this.detect(image, ImageProcessingOptions.builder().build());
    }

    public List<Detection> detect(TensorImage image, ImageProcessingOptions options) {
        this.checkNotClosed();
        TensorImage imageUint8 = image.getDataType() == DataType.UINT8 ? image : TensorImage.createFrom((TensorImage)image, (DataType)DataType.UINT8);
        return ObjectDetector.detectNative(this.getNativeHandle(), imageUint8.getBuffer(), imageUint8.getWidth(), imageUint8.getHeight(), options.getOrientation().getValue());
    }

    private static native long initJniWithModelFdAndOptions(int var0, long var1, long var3, ObjectDetectorOptions var5);

    private static native List<Detection> detectNative(long var0, ByteBuffer var2, int var3, int var4, int var5);

    protected void deinit(long nativeHandle) {
        this.deinitJni(nativeHandle);
    }

    private native void deinitJni(long var1);

    @UsedByReflection(value="object_detector_jni.cc")
    public static class ObjectDetectorOptions {
        private final String displayNamesLocale;
        private final int maxResults;
        private final float scoreThreshold;
        private final boolean isScoreThresholdSet;
        private final List<String> labelAllowList;
        private final List<String> labelDenyList;

        public static Builder builder() {
            return new Builder();
        }

        @UsedByReflection(value="object_detector_jni.cc")
        public String getDisplayNamesLocale() {
            return this.displayNamesLocale;
        }

        @UsedByReflection(value="object_detector_jni.cc")
        public int getMaxResults() {
            return this.maxResults;
        }

        @UsedByReflection(value="object_detector_jni.cc")
        public float getScoreThreshold() {
            return this.scoreThreshold;
        }

        @UsedByReflection(value="object_detector_jni.cc")
        public boolean getIsScoreThresholdSet() {
            return this.isScoreThresholdSet;
        }

        @UsedByReflection(value="object_detector_jni.cc")
        public List<String> getLabelAllowList() {
            return new ArrayList<String>(this.labelAllowList);
        }

        @UsedByReflection(value="object_detector_jni.cc")
        public List<String> getLabelDenyList() {
            return new ArrayList<String>(this.labelDenyList);
        }

        private ObjectDetectorOptions(Builder builder) {
            this.displayNamesLocale = builder.displayNamesLocale;
            this.maxResults = builder.maxResults;
            this.scoreThreshold = builder.scoreThreshold;
            this.isScoreThresholdSet = builder.isScoreThresholdSet;
            this.labelAllowList = builder.labelAllowList;
            this.labelDenyList = builder.labelDenyList;
        }

        public static class Builder {
            private String displayNamesLocale = "en";
            private int maxResults = -1;
            private float scoreThreshold;
            private boolean isScoreThresholdSet = false;
            private List<String> labelAllowList = new ArrayList<String>();
            private List<String> labelDenyList = new ArrayList<String>();

            private Builder() {
            }

            public Builder setDisplayNamesLocale(String displayNamesLocale) {
                this.displayNamesLocale = displayNamesLocale;
                return this;
            }

            public Builder setMaxResults(int maxResults) {
                if (maxResults == 0) {
                    throw new IllegalArgumentException("maxResults cannot be 0.");
                }
                this.maxResults = maxResults;
                return this;
            }

            public Builder setScoreThreshold(float scoreThreshold) {
                this.scoreThreshold = scoreThreshold;
                this.isScoreThresholdSet = true;
                return this;
            }

            public Builder setLabelAllowList(List<String> labelAllowList) {
                this.labelAllowList = Collections.unmodifiableList(new ArrayList<String>(labelAllowList));
                return this;
            }

            public Builder setLabelDenyList(List<String> labelDenyList) {
                this.labelDenyList = Collections.unmodifiableList(new ArrayList<String>(labelDenyList));
                return this;
            }

            public ObjectDetectorOptions build() {
                return new ObjectDetectorOptions(this);
            }
        }
    }
}

