/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.task.vision.classifier;

import android.content.Context;
import android.graphics.Rect;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.annotations.UsedByReflection;
import org.tensorflow.lite.support.image.TensorImage;
import org.tensorflow.lite.task.core.BaseTaskApi;
import org.tensorflow.lite.task.core.TaskJniUtils;
import org.tensorflow.lite.task.core.vision.ImageProcessingOptions;
import org.tensorflow.lite.task.vision.classifier.Classifications;

public final class ImageClassifier
extends BaseTaskApi {
    private static final String IMAGE_CLASSIFIER_NATIVE_LIB = "task_vision_jni";

    public static ImageClassifier createFromFile(Context context, String modelPath) throws IOException {
        return ImageClassifier.createFromFileAndOptions(context, modelPath, ImageClassifierOptions.builder().build());
    }

    public static ImageClassifier createFromFileAndOptions(Context context, String modelPath, ImageClassifierOptions options) throws IOException {
        return new ImageClassifier(TaskJniUtils.createHandleFromFdAndOptions((Context)context, (TaskJniUtils.FdAndOptionsHandleProvider)new TaskJniUtils.FdAndOptionsHandleProvider<ImageClassifierOptions>(){

            public long createHandle(int fileDescriptor, long fileDescriptorLength, long fileDescriptorOffset, ImageClassifierOptions options) {
                return ImageClassifier.initJniWithModelFdAndOptions(fileDescriptor, fileDescriptorLength, fileDescriptorOffset, options);
            }
        }, (String)IMAGE_CLASSIFIER_NATIVE_LIB, (String)modelPath, (Object)options));
    }

    private ImageClassifier(long nativeHandle) {
        super(nativeHandle);
    }

    public List<Classifications> classify(TensorImage image) {
        return this.classify(image, ImageProcessingOptions.builder().build());
    }

    public List<Classifications> classify(TensorImage image, ImageProcessingOptions options) {
        this.checkNotClosed();
        TensorImage imageUint8 = image.getDataType() == DataType.UINT8 ? image : TensorImage.createFrom((TensorImage)image, (DataType)DataType.UINT8);
        Rect roi = options.getRoi().isEmpty() ? new Rect(0, 0, imageUint8.getWidth(), imageUint8.getHeight()) : options.getRoi();
        return ImageClassifier.classifyNative(this.getNativeHandle(), imageUint8.getBuffer(), imageUint8.getWidth(), imageUint8.getHeight(), new int[]{roi.left, roi.top, roi.width(), roi.height()}, options.getOrientation().getValue());
    }

    private static native long initJniWithModelFdAndOptions(int var0, long var1, long var3, ImageClassifierOptions var5);

    private static native List<Classifications> classifyNative(long var0, ByteBuffer var2, int var3, int var4, int[] var5, int var6);

    protected void deinit(long nativeHandle) {
        this.deinitJni(nativeHandle);
    }

    private native void deinitJni(long var1);

    @UsedByReflection(value="image_classifier_jni.cc")
    public static class ImageClassifierOptions {
        private final String displayNamesLocale;
        private final int maxResults;
        private final float scoreThreshold;
        private final boolean isScoreThresholdSet;
        private final List<String> labelAllowList;
        private final List<String> labelDenyList;

        public static Builder builder() {
            return new Builder();
        }

        @UsedByReflection(value="image_classifier_jni.cc")
        public String getDisplayNamesLocale() {
            return this.displayNamesLocale;
        }

        @UsedByReflection(value="image_classifier_jni.cc")
        public int getMaxResults() {
            return this.maxResults;
        }

        @UsedByReflection(value="image_classifier_jni.cc")
        public float getScoreThreshold() {
            return this.scoreThreshold;
        }

        @UsedByReflection(value="image_classifier_jni.cc")
        public boolean getIsScoreThresholdSet() {
            return this.isScoreThresholdSet;
        }

        @UsedByReflection(value="image_classifier_jni.cc")
        public List<String> getLabelAllowList() {
            return new ArrayList<String>(this.labelAllowList);
        }

        @UsedByReflection(value="image_classifier_jni.cc")
        public List<String> getLabelDenyList() {
            return new ArrayList<String>(this.labelDenyList);
        }

        private ImageClassifierOptions(Builder builder) {
            this.displayNamesLocale = builder.displayNamesLocale;
            this.maxResults = builder.maxResults;
            this.scoreThreshold = builder.scoreThreshold;
            this.isScoreThresholdSet = builder.isScoreThresholdSet;
            this.labelAllowList = builder.labelAllowList;
            this.labelDenyList = builder.labelDenyList;
        }

        public static class Builder {
            private String displayNamesLocale = "en";
            private int maxResults = -1;
            private float scoreThreshold;
            private boolean isScoreThresholdSet = false;
            private List<String> labelAllowList = new ArrayList<String>();
            private List<String> labelDenyList = new ArrayList<String>();

            private Builder() {
            }

            public Builder setDisplayNamesLocale(String displayNamesLocale) {
                this.displayNamesLocale = displayNamesLocale;
                return this;
            }

            public Builder setMaxResults(int maxResults) {
                if (maxResults == 0) {
                    throw new IllegalArgumentException("maxResults cannot be 0.");
                }
                this.maxResults = maxResults;
                return this;
            }

            public Builder setScoreThreshold(float scoreThreshold) {
                this.scoreThreshold = scoreThreshold;
                this.isScoreThresholdSet = true;
                return this;
            }

            public Builder setLabelAllowList(List<String> labelAllowList) {
                this.labelAllowList = Collections.unmodifiableList(new ArrayList<String>(labelAllowList));
                return this;
            }

            public Builder setLabelDenyList(List<String> labelDenyList) {
                this.labelDenyList = Collections.unmodifiableList(new ArrayList<String>(labelDenyList));
                return this;
            }

            public ImageClassifierOptions build() {
                return new ImageClassifierOptions(this);
            }
        }
    }
}

