/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.schema;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.IntVector;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.tensorflow.lite.schema.Operator;
import org.tensorflow.lite.schema.OperatorT;
import org.tensorflow.lite.schema.SubGraphT;
import org.tensorflow.lite.schema.Tensor;
import org.tensorflow.lite.schema.TensorT;

public final class SubGraph
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_23_5_26();
    }

    public static SubGraph getRootAsSubGraph(ByteBuffer _bb) {
        return SubGraph.getRootAsSubGraph(_bb, new SubGraph());
    }

    public static SubGraph getRootAsSubGraph(ByteBuffer _bb, SubGraph obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public SubGraph __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public Tensor tensors(int j) {
        return this.tensors(new Tensor(), j);
    }

    public Tensor tensors(Tensor obj, int j) {
        int o = this.__offset(4);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int tensorsLength() {
        int o = this.__offset(4);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public Tensor.Vector tensorsVector() {
        return this.tensorsVector(new Tensor.Vector());
    }

    public Tensor.Vector tensorsVector(Tensor.Vector obj) {
        int o = this.__offset(4);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public int inputs(int j) {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getInt(this.__vector(o) + j * 4) : 0;
    }

    public int inputsLength() {
        int o = this.__offset(6);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public IntVector inputsVector() {
        return this.inputsVector(new IntVector());
    }

    public IntVector inputsVector(IntVector obj) {
        int o = this.__offset(6);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer inputsAsByteBuffer() {
        return this.__vector_as_bytebuffer(6, 4);
    }

    public ByteBuffer inputsInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 6, 4);
    }

    public int outputs(int j) {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getInt(this.__vector(o) + j * 4) : 0;
    }

    public int outputsLength() {
        int o = this.__offset(8);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public IntVector outputsVector() {
        return this.outputsVector(new IntVector());
    }

    public IntVector outputsVector(IntVector obj) {
        int o = this.__offset(8);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer outputsAsByteBuffer() {
        return this.__vector_as_bytebuffer(8, 4);
    }

    public ByteBuffer outputsInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 8, 4);
    }

    public Operator operators(int j) {
        return this.operators(new Operator(), j);
    }

    public Operator operators(Operator obj, int j) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int operatorsLength() {
        int o = this.__offset(10);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public Operator.Vector operatorsVector() {
        return this.operatorsVector(new Operator.Vector());
    }

    public Operator.Vector operatorsVector(Operator.Vector obj) {
        int o = this.__offset(10);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public String name() {
        int o = this.__offset(12);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer nameAsByteBuffer() {
        return this.__vector_as_bytebuffer(12, 1);
    }

    public ByteBuffer nameInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 12, 1);
    }

    public static int createSubGraph(FlatBufferBuilder builder, int tensorsOffset, int inputsOffset, int outputsOffset, int operatorsOffset, int nameOffset) {
        builder.startTable(5);
        SubGraph.addName(builder, nameOffset);
        SubGraph.addOperators(builder, operatorsOffset);
        SubGraph.addOutputs(builder, outputsOffset);
        SubGraph.addInputs(builder, inputsOffset);
        SubGraph.addTensors(builder, tensorsOffset);
        return SubGraph.endSubGraph(builder);
    }

    public static void startSubGraph(FlatBufferBuilder builder) {
        builder.startTable(5);
    }

    public static void addTensors(FlatBufferBuilder builder, int tensorsOffset) {
        builder.addOffset(0, tensorsOffset, 0);
    }

    public static int createTensorsVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startTensorsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addInputs(FlatBufferBuilder builder, int inputsOffset) {
        builder.addOffset(1, inputsOffset, 0);
    }

    public static int createInputsVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startInputsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addOutputs(FlatBufferBuilder builder, int outputsOffset) {
        builder.addOffset(2, outputsOffset, 0);
    }

    public static int createOutputsVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startOutputsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addOperators(FlatBufferBuilder builder, int operatorsOffset) {
        builder.addOffset(3, operatorsOffset, 0);
    }

    public static int createOperatorsVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startOperatorsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addName(FlatBufferBuilder builder, int nameOffset) {
        builder.addOffset(4, nameOffset, 0);
    }

    public static int endSubGraph(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public SubGraphT unpack() {
        SubGraphT _o = new SubGraphT();
        this.unpackTo(_o);
        return _o;
    }

    public void unpackTo(SubGraphT _o) {
        TensorT[] _oTensors = new TensorT[this.tensorsLength()];
        for (int _j = 0; _j < this.tensorsLength(); ++_j) {
            _oTensors[_j] = this.tensors(_j) != null ? this.tensors(_j).unpack() : null;
        }
        _o.setTensors(_oTensors);
        int[] _oInputs = new int[this.inputsLength()];
        for (int _j = 0; _j < this.inputsLength(); ++_j) {
            _oInputs[_j] = this.inputs(_j);
        }
        _o.setInputs(_oInputs);
        int[] _oOutputs = new int[this.outputsLength()];
        for (int _j = 0; _j < this.outputsLength(); ++_j) {
            _oOutputs[_j] = this.outputs(_j);
        }
        _o.setOutputs(_oOutputs);
        OperatorT[] _oOperators = new OperatorT[this.operatorsLength()];
        for (int _j = 0; _j < this.operatorsLength(); ++_j) {
            _oOperators[_j] = this.operators(_j) != null ? this.operators(_j).unpack() : null;
        }
        _o.setOperators(_oOperators);
        String _oName = this.name();
        _o.setName(_oName);
    }

    public static int pack(FlatBufferBuilder builder, SubGraphT _o) {
        if (_o == null) {
            return 0;
        }
        int _tensors = 0;
        if (_o.getTensors() != null) {
            int[] __tensors = new int[_o.getTensors().length];
            int _j = 0;
            for (TensorT _e : _o.getTensors()) {
                __tensors[_j] = Tensor.pack(builder, _e);
                ++_j;
            }
            _tensors = SubGraph.createTensorsVector(builder, __tensors);
        }
        int _inputs = 0;
        if (_o.getInputs() != null) {
            _inputs = SubGraph.createInputsVector(builder, _o.getInputs());
        }
        int _outputs = 0;
        if (_o.getOutputs() != null) {
            _outputs = SubGraph.createOutputsVector(builder, _o.getOutputs());
        }
        int _operators = 0;
        if (_o.getOperators() != null) {
            int[] __operators = new int[_o.getOperators().length];
            int _j = 0;
            for (OperatorT _e : _o.getOperators()) {
                __operators[_j] = Operator.pack(builder, _e);
                ++_j;
            }
            _operators = SubGraph.createOperatorsVector(builder, __operators);
        }
        int _name = _o.getName() == null ? 0 : builder.createString((CharSequence)_o.getName());
        return SubGraph.createSubGraph(builder, _tensors, _inputs, _outputs, _operators, _name);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public SubGraph get(int j) {
            return this.get(new SubGraph(), j);
        }

        public SubGraph get(SubGraph obj, int j) {
            return obj.__assign(SubGraph.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

