/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.metadata;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import org.tensorflow.lite.support.metadata.BoundedInputStream;
import org.tensorflow.lite.support.metadata.ByteBufferChannel;
import org.tensorflow.lite.support.metadata.Preconditions;

final class ZipFile
implements Closeable {
    private final Map<String, List<ZipEntry>> nameMap;
    private final ByteBufferChannel archive;

    public static ZipFile createFrom(ByteBufferChannel channel) throws IOException {
        Preconditions.checkNotNull(channel);
        ZipParser zipParser = new ZipParser(channel);
        Map nameMap = zipParser.parseEntries();
        return new ZipFile(channel, nameMap);
    }

    @Override
    public void close() {
        this.archive.close();
    }

    public InputStream getRawInputStream(String name) {
        Preconditions.checkArgument(this.nameMap.containsKey(name), String.format("The file, %s, does not exist in the zip file.", name));
        List<ZipEntry> entriesWithTheSameName = this.nameMap.get(name);
        ZipEntry entry = entriesWithTheSameName.get(0);
        long start = entry.getDataOffset();
        long remaining = entry.getSize();
        return new BoundedInputStream(this.archive, start, remaining);
    }

    private ZipFile(ByteBufferChannel channel, Map<String, List<ZipEntry>> nameMap) {
        this.archive = channel;
        this.nameMap = nameMap;
    }

    private static class ZipConstants {
        static final int SHORT_BYTE_SIZE = 2;
        static final int INT_BYTE_SIZE = 4;
        static final int LONG_BYTE_SIZE = 8;
        static final long LOCSIG = 67324752L;
        static final long EXTSIG = 134695760L;
        static final long CENSIG = 33639248L;
        static final long ENDSIG = 101010256L;
        static final int LOCHDR = 30;
        static final int EXTHDR = 16;
        static final int CENHDR = 46;
        static final int ENDHDR = 22;
        static final int LOCVER = 4;
        static final int LOCFLG = 6;
        static final int LOCHOW = 8;
        static final int LOCTIM = 10;
        static final int LOCCRC = 14;
        static final int LOCSIZ = 18;
        static final int LOCLEN = 22;
        static final int LOCNAM = 26;
        static final int LOCEXT = 28;
        static final int EXTCRC = 4;
        static final int EXTSIZ = 8;
        static final int EXTLEN = 12;
        static final int CENVEM = 4;
        static final int CENVER = 6;
        static final int CENFLG = 8;
        static final int CENHOW = 10;
        static final int CENTIM = 12;
        static final int CENCRC = 16;
        static final int CENSIZ = 20;
        static final int CENLEN = 24;
        static final int CENNAM = 28;
        static final int CENEXT = 30;
        static final int CENCOM = 32;
        static final int CENDSK = 34;
        static final int CENATT = 36;
        static final int CENATX = 38;
        static final int CENOFF = 42;
        static final int ENDSUB = 8;
        static final int ENDTOT = 10;
        static final int ENDSIZ = 12;
        static final int ENDOFF = 16;
        static final int ENDCOM = 20;

        private ZipConstants() {
        }
    }

    private static class ZipEntry {
        private String name;
        private long dataOffset = -1L;
        private long size = -1L;
        private long localHeaderOffset = -1L;

        private ZipEntry() {
        }

        public long getSize() {
            return this.size;
        }

        public long getDataOffset() {
            return this.dataOffset;
        }

        public String getName() {
            return this.name;
        }

        public long getLocalHeaderOffset() {
            return this.localHeaderOffset;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public void setDataOffset(long dataOffset) {
            this.dataOffset = dataOffset;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setLocalHeaderOffset(long localHeaderOffset) {
            this.localHeaderOffset = localHeaderOffset;
        }
    }

    private static class ZipParser {
        private final ByteBufferChannel archive;
        private final ByteBuffer longBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        private final ByteBuffer intBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        private final ByteBuffer shortBuffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);

        private ZipParser(ByteBufferChannel archive) {
            this.archive = archive;
        }

        private Map<String, List<ZipEntry>> parseEntries() throws IOException {
            List<ZipEntry> entries = this.parseCentralDirectory();
            return this.parseLocalFileHeaderData(entries);
        }

        private boolean foundCentralFileheaderSignature() {
            long signature = this.getInt();
            return signature == 33639248L;
        }

        private int getShort() {
            this.shortBuffer.rewind();
            this.archive.read(this.shortBuffer);
            this.shortBuffer.flip();
            return this.shortBuffer.getShort();
        }

        private int getInt() {
            this.intBuffer.rewind();
            this.archive.read(this.intBuffer);
            this.intBuffer.flip();
            return this.intBuffer.getInt();
        }

        private long getLong() {
            this.longBuffer.rewind();
            this.archive.read(this.longBuffer);
            this.longBuffer.flip();
            return this.longBuffer.getLong();
        }

        private void locateCentralDirectory() throws IOException {
            if (this.archive.size() < 22L) {
                throw new ZipException("The archive is not a ZIP archive.");
            }
            long offsetRecord = this.archive.size() - 22L;
            this.archive.position(offsetRecord);
            long endSig = this.getLong();
            if (endSig != 101010256L) {
                throw new ZipException("The archive is not a ZIP archive.");
            }
            this.skipBytes(8);
            long offsetDirectory = this.getInt();
            this.archive.position(offsetDirectory);
        }

        private List<ZipEntry> parseCentralDirectory() throws IOException {
            ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
            this.locateCentralDirectory();
            while (this.foundCentralFileheaderSignature()) {
                ZipEntry entry = this.parseCentralDirectoryEntry();
                entries.add(entry);
            }
            return entries;
        }

        private ZipEntry parseCentralDirectoryEntry() throws IOException {
            this.skipBytes(16);
            long compressSize = this.getInt();
            this.skipBytes(4);
            int fileNameLen = this.getShort();
            int extraLen = this.getShort();
            int commentLen = this.getShort();
            this.skipBytes(8);
            long localHeaderOffset = this.getInt();
            byte[] fileNameBuf = new byte[fileNameLen];
            this.archive.read(ByteBuffer.wrap(fileNameBuf));
            String fileName = new String(fileNameBuf, Charset.forName("UTF-8"));
            this.skipBytes(extraLen + commentLen);
            ZipEntry entry = new ZipEntry();
            entry.setSize(compressSize);
            entry.setLocalHeaderOffset(localHeaderOffset);
            entry.setName(fileName);
            return entry;
        }

        private Map<String, List<ZipEntry>> parseLocalFileHeaderData(List<ZipEntry> entries) {
            LinkedHashMap<String, List<ZipEntry>> nameMap = new LinkedHashMap<String, List<ZipEntry>>();
            for (ZipEntry entry : entries) {
                List<ZipEntry> entriesWithTheSameName;
                long offset = entry.getLocalHeaderOffset();
                this.archive.position(offset + 26L);
                int fileNameLen = this.getShort();
                int extraFieldLen = this.getShort();
                long dataOffset = offset + 28L + 2L + (long)fileNameLen + (long)extraFieldLen;
                entry.setDataOffset(dataOffset);
                String name = entry.getName();
                if (nameMap.containsKey(name)) {
                    entriesWithTheSameName = (List)nameMap.get(name);
                } else {
                    entriesWithTheSameName = new ArrayList();
                    nameMap.put(name, entriesWithTheSameName);
                }
                entriesWithTheSameName.add(entry);
            }
            return nameMap;
        }

        private void skipBytes(int count) throws IOException {
            long currentPosition = this.archive.position();
            long newPosition = currentPosition + (long)count;
            if (newPosition > this.archive.size()) {
                throw new EOFException();
            }
            this.archive.position(newPosition);
        }
    }
}

