/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.nnapi;

import org.tensorflow.lite.Delegate;
import org.tensorflow.lite.InterpreterFactoryApi;
import org.tensorflow.lite.TensorFlowLite;

public class NnApiDelegate
implements Delegate,
AutoCloseable {
    private Options options;
    private PrivateInterface impl;
    private boolean initialized;

    public NnApiDelegate(Options options) {
        TensorFlowLite.init();
        this.options = options;
    }

    public NnApiDelegate() {
        this(new Options());
    }

    public void initWithInterpreterFactoryApi(InterpreterFactoryApi interpreterFactoryApi) {
        this.impl = interpreterFactoryApi.createNnApiDelegateImpl(this.options);
        this.initialized = true;
    }

    @Override
    public long getNativeHandle() {
        this.checkNotClosed();
        return this.impl.getNativeHandle();
    }

    @Override
    public void close() {
        if (this.impl != null) {
            this.impl.close();
            this.impl = null;
        }
    }

    public int getNnapiErrno() {
        if (!this.initialized) {
            return 0;
        }
        this.checkNotClosed();
        return this.impl.getNnapiErrno();
    }

    public boolean hasErrors() {
        return this.getNnapiErrno() != 0;
    }

    private void checkNotClosed() {
        if (this.impl == null) {
            throw new IllegalStateException(this.initialized ? "Should not access delegate after delegate has been closed." : "Should not access delegate before interpreter has been constructed.");
        }
    }

    public static final class Options {
        public static final int EXECUTION_PREFERENCE_UNDEFINED = -1;
        public static final int EXECUTION_PREFERENCE_LOW_POWER = 0;
        public static final int EXECUTION_PREFERENCE_FAST_SINGLE_ANSWER = 1;
        public static final int EXECUTION_PREFERENCE_SUSTAINED_SPEED = 2;
        private int executionPreference = -1;
        private String acceleratorName = null;
        private String cacheDir = null;
        private String modelToken = null;
        private Integer maxDelegatedPartitions = null;
        private Boolean useNnapiCpu = null;
        private Boolean allowFp16 = null;
        private long nnApiSupportLibraryHandle = 0L;

        public Options setExecutionPreference(int preference) {
            this.executionPreference = preference;
            return this;
        }

        public Options setAcceleratorName(String name) {
            this.acceleratorName = name;
            return this;
        }

        public Options setCacheDir(String cacheDir) {
            this.cacheDir = cacheDir;
            return this;
        }

        public Options setModelToken(String modelToken) {
            this.modelToken = modelToken;
            return this;
        }

        public Options setMaxNumberOfDelegatedPartitions(int limit) {
            this.maxDelegatedPartitions = limit;
            return this;
        }

        public Options setUseNnapiCpu(boolean enable) {
            this.useNnapiCpu = enable;
            return this;
        }

        public Options setAllowFp16(boolean enable) {
            this.allowFp16 = enable;
            return this;
        }

        public Options setNnApiSupportLibraryHandle(long handle) {
            this.nnApiSupportLibraryHandle = handle;
            return this;
        }

        public int getExecutionPreference() {
            return this.executionPreference;
        }

        public String getAcceleratorName() {
            return this.acceleratorName;
        }

        public String getCacheDir() {
            return this.cacheDir;
        }

        public String getModelToken() {
            return this.modelToken;
        }

        public int getMaxNumberOfDelegatedPartitions() {
            return this.maxDelegatedPartitions == null ? -1 : this.maxDelegatedPartitions;
        }

        public Boolean getUseNnapiCpu() {
            return this.useNnapiCpu;
        }

        public boolean getAllowFp16() {
            return this.allowFp16 != null && this.allowFp16 != false;
        }

        public long getNnApiSupportLibraryHandle() {
            return this.nnApiSupportLibraryHandle;
        }
    }

    public static interface PrivateInterface
    extends Delegate,
    AutoCloseable {
        public int getNnapiErrno();

        @Override
        public void close();
    }
}

