/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite;

public enum DataType {
    FLOAT32(1),
    INT32(2),
    UINT8(3),
    INT64(4),
    STRING(5),
    BOOL(6),
    INT16(7),
    INT8(9);

    private final int value;
    private static final DataType[] values;

    private DataType(int value) {
        this.value = value;
    }

    public int byteSize() {
        switch (this) {
            case FLOAT32: 
            case INT32: {
                return 4;
            }
            case INT16: {
                return 2;
            }
            case INT8: 
            case UINT8: {
                return 1;
            }
            case INT64: {
                return 8;
            }
            case BOOL: {
                return -1;
            }
            case STRING: {
                return -1;
            }
        }
        throw new IllegalArgumentException("DataType error: DataType " + (Object)((Object)this) + " is not supported yet");
    }

    int c() {
        return this.value;
    }

    static {
        values = DataType.values();
    }
}

