/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer.raw;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

final class UnsafeReference {
    static final Unsafe UNSAFE;

    UnsafeReference() {
    }

    static boolean isAvailable() {
        return UNSAFE != null;
    }

    private static void checkMethod(Class<?> unsafeClass, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        unsafeClass.getDeclaredMethod(methodName, parameterTypes);
    }

    static {
        Unsafe unsafe = null;
        try {
            Class<?> clazz = Class.forName("sun.misc.Unsafe");
            Field theUnsafe = clazz.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            Object instance = theUnsafe.get(null);
            if (instance.getClass() == clazz) {
                UnsafeReference.checkMethod(clazz, "getByte", Object.class, Long.TYPE);
                UnsafeReference.checkMethod(clazz, "putByte", Object.class, Long.TYPE, Byte.TYPE);
                UnsafeReference.checkMethod(clazz, "getShort", Object.class, Long.TYPE);
                UnsafeReference.checkMethod(clazz, "putShort", Object.class, Long.TYPE, Short.TYPE);
                UnsafeReference.checkMethod(clazz, "getInt", Object.class, Long.TYPE);
                UnsafeReference.checkMethod(clazz, "putInt", Object.class, Long.TYPE, Integer.TYPE);
                UnsafeReference.checkMethod(clazz, "getLong", Object.class, Long.TYPE);
                UnsafeReference.checkMethod(clazz, "putLong", Object.class, Long.TYPE, Long.TYPE);
                UnsafeReference.checkMethod(clazz, "getFloat", Object.class, Long.TYPE);
                UnsafeReference.checkMethod(clazz, "putFloat", Object.class, Long.TYPE, Float.TYPE);
                UnsafeReference.checkMethod(clazz, "getDouble", Object.class, Long.TYPE);
                UnsafeReference.checkMethod(clazz, "putDouble", Object.class, Long.TYPE, Double.TYPE);
                UnsafeReference.checkMethod(clazz, "getBoolean", Object.class, Long.TYPE);
                UnsafeReference.checkMethod(clazz, "putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
                UnsafeReference.checkMethod(clazz, "copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
                UnsafeReference.checkMethod(clazz, "arrayBaseOffset", Class.class);
                UnsafeReference.checkMethod(clazz, "arrayIndexScale", Class.class);
                unsafe = (Unsafe)instance;
            }
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        UNSAFE = unsafe;
    }
}

