/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer.adapter;

import org.tensorflow.ndarray.buffer.BooleanDataBuffer;
import org.tensorflow.ndarray.buffer.ByteDataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.DoubleDataBuffer;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import org.tensorflow.ndarray.buffer.LongDataBuffer;
import org.tensorflow.ndarray.buffer.ShortDataBuffer;
import org.tensorflow.ndarray.buffer.layout.ByteDataLayout;
import org.tensorflow.ndarray.impl.buffer.Validator;
import org.tensorflow.ndarray.impl.buffer.adapter.AbstractDataBufferAdapter;

class ByteDataBufferAdapter<S extends DataBuffer<?>>
extends AbstractDataBufferAdapter<S, Byte, ByteDataBuffer>
implements ByteDataBuffer {
    private ByteDataLayout<S> layout;

    @Override
    public byte getByte(long index) {
        Validator.getArgs(this, index);
        return this.layout.readByte(this.buffer(), index * (long)this.layout.scale());
    }

    @Override
    public ByteDataBuffer setByte(byte value, long index) {
        Validator.setArgs(this, index);
        this.layout.writeByte(this.buffer(), value, index * (long)this.layout.scale());
        return this;
    }

    @Override
    public ByteDataBuffer read(byte[] dst, int offset, int length) {
        Validator.readArgs(this, dst.length, offset, length);
        int i = 0;
        int j = offset;
        while (i < length) {
            dst[j] = this.layout.readByte(this.buffer(), i * this.layout.scale());
            ++i;
            ++j;
        }
        return this;
    }

    @Override
    public ByteDataBuffer write(byte[] src, int offset, int length) {
        Validator.writeArgs(this, src.length, offset, length);
        int i = 0;
        int j = offset;
        while (i < length) {
            this.layout.writeByte(this.buffer(), src[j], i * this.layout.scale());
            ++i;
            ++j;
        }
        return this;
    }

    @Override
    public ByteDataBuffer copyTo(DataBuffer<Byte> dst, long size) {
        Validator.copyToArgs(this, dst, size);
        if (dst instanceof ByteDataBuffer) {
            ByteDataBuffer byteDst = (ByteDataBuffer)dst;
            for (long idx = 0L; idx < size; ++idx) {
                byteDst.setByte(this.getByte(idx), idx);
            }
            return this;
        }
        return (ByteDataBuffer)this.slowCopyTo(dst, size);
    }

    @Override
    public IntDataBuffer asInts() {
        throw new IllegalStateException("Byte buffers with layout cannot be converted");
    }

    @Override
    public ShortDataBuffer asShorts() {
        throw new IllegalStateException("Byte buffers with layout cannot be converted");
    }

    @Override
    public LongDataBuffer asLongs() {
        throw new IllegalStateException("Byte buffers with layout cannot be converted");
    }

    @Override
    public FloatDataBuffer asFloats() {
        throw new IllegalStateException("Byte buffers with layout cannot be converted");
    }

    @Override
    public DoubleDataBuffer asDoubles() {
        throw new IllegalStateException("Byte buffers with layout cannot be converted");
    }

    @Override
    public BooleanDataBuffer asBooleans() {
        throw new IllegalStateException("Byte buffers with layout cannot be converted");
    }

    @Override
    public ByteDataBuffer offset(long index) {
        return new ByteDataBufferAdapter(this.buffer().offset(index * (long)this.layout.scale()), this.layout);
    }

    @Override
    public ByteDataBuffer narrow(long size) {
        return new ByteDataBufferAdapter(this.buffer().narrow(size * (long)this.layout.scale()), this.layout);
    }

    @Override
    public ByteDataBuffer slice(long index, long size) {
        return new ByteDataBufferAdapter(this.buffer().slice(index * (long)this.layout.scale(), size * (long)this.layout.scale()), this.layout);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteDataBuffer)) {
            return super.equals(obj);
        }
        ByteDataBuffer other = (ByteDataBuffer)obj;
        if (other.size() != this.size()) {
            return false;
        }
        for (long idx = 0L; idx < this.size(); ++idx) {
            if (other.getByte(idx) == this.getByte(idx)) continue;
            return false;
        }
        return true;
    }

    ByteDataBufferAdapter(S buffer, ByteDataLayout<S> layout) {
        super(buffer, layout);
        this.layout = layout;
    }
}

