/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseReduceMaxSparse<T extends Number>
extends PrimitiveOp {
    private Output<Long> outputIndices;
    private Output<T> outputValues;
    private Output<Long> outputShape;

    public static <T extends Number> SparseReduceMaxSparse<T> create(Scope scope, Operand<Long> inputIndices, Operand<T> inputValues, Operand<Long> inputShape, Operand<Integer> reductionAxes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("SparseReduceMaxSparse", scope.makeOpName("SparseReduceMaxSparse"));
        opBuilder.addInput(inputIndices.asOutput());
        opBuilder.addInput(inputValues.asOutput());
        opBuilder.addInput(inputShape.asOutput());
        opBuilder.addInput(reductionAxes.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.keepDims == null) continue;
                opBuilder.setAttr("keep_dims", opts.keepDims);
            }
        }
        return new SparseReduceMaxSparse<T>(opBuilder.build());
    }

    public static Options keepDims(Boolean keepDims) {
        return new Options().keepDims(keepDims);
    }

    public Output<Long> outputIndices() {
        return this.outputIndices;
    }

    public Output<T> outputValues() {
        return this.outputValues;
    }

    public Output<Long> outputShape() {
        return this.outputShape;
    }

    private SparseReduceMaxSparse(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.outputIndices = operation.output(outputIdx++);
        this.outputValues = operation.output(outputIdx++);
        this.outputShape = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean keepDims;

        public Options keepDims(Boolean keepDims) {
            this.keepDims = keepDims;
            return this;
        }

        private Options() {
        }
    }
}

