/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ParseExampleDataset
extends PrimitiveOp
implements Operand<Object> {
    private Output<?> handle;

    public static ParseExampleDataset create(Scope scope, Operand<?> inputDataset, Operand<Long> numParallelCalls, Iterable<Operand<?>> denseDefaults, List<String> sparseKeys, List<String> denseKeys, List<Class<?>> sparseTypes, List<Shape> denseShapes, List<Class<?>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("ParseExampleDataset", scope.makeOpName("ParseExampleDataset"));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(numParallelCalls.asOutput());
        opBuilder.addInputList(Operands.asOutputs(denseDefaults));
        opBuilder = scope.applyControlDependencies(opBuilder);
        String[] sparseKeysArray = new String[sparseKeys.size()];
        for (int i = 0; i < sparseKeysArray.length; ++i) {
            sparseKeysArray[i] = sparseKeys.get(i);
        }
        opBuilder.setAttr("sparse_keys", sparseKeysArray);
        String[] denseKeysArray = new String[denseKeys.size()];
        for (int i = 0; i < denseKeysArray.length; ++i) {
            denseKeysArray[i] = denseKeys.get(i);
        }
        opBuilder.setAttr("dense_keys", denseKeysArray);
        DataType[] sparseTypesArray = new DataType[sparseTypes.size()];
        for (int i = 0; i < sparseTypesArray.length; ++i) {
            sparseTypesArray[i] = DataType.fromClass(sparseTypes.get(i));
        }
        opBuilder.setAttr("sparse_types", sparseTypesArray);
        Shape[] denseShapesArray = new Shape[denseShapes.size()];
        for (int i = 0; i < denseShapesArray.length; ++i) {
            denseShapesArray[i] = denseShapes.get(i);
        }
        opBuilder.setAttr("dense_shapes", denseShapesArray);
        DataType[] outputTypesArray = new DataType[outputTypes.size()];
        for (int i = 0; i < outputTypesArray.length; ++i) {
            outputTypesArray[i] = DataType.fromClass(outputTypes.get(i));
        }
        opBuilder.setAttr("output_types", outputTypesArray);
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.sloppy == null) continue;
                opBuilder.setAttr("sloppy", opts.sloppy);
            }
        }
        return new ParseExampleDataset(opBuilder.build());
    }

    public static Options sloppy(Boolean sloppy) {
        return new Options().sloppy(sloppy);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<Object> asOutput() {
        return this.handle;
    }

    private ParseExampleDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean sloppy;

        public Options sloppy(Boolean sloppy) {
            this.sloppy = sloppy;
            return this;
        }

        private Options() {
        }
    }
}

