/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ModelDataset
extends PrimitiveOp
implements Operand<Object> {
    private Output<?> handle;

    public static ModelDataset create(Scope scope, Operand<?> inputDataset, List<Class<?>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("ModelDataset", scope.makeOpName("ModelDataset"));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] outputTypesArray = new DataType[outputTypes.size()];
        for (int i = 0; i < outputTypesArray.length; ++i) {
            outputTypesArray[i] = DataType.fromClass(outputTypes.get(i));
        }
        opBuilder.setAttr("output_types", outputTypesArray);
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.algorithm != null) {
                    opBuilder.setAttr("algorithm", opts.algorithm);
                }
                if (opts.cpuBudget == null) continue;
                opBuilder.setAttr("cpu_budget", opts.cpuBudget);
            }
        }
        return new ModelDataset(opBuilder.build());
    }

    public static Options algorithm(Long algorithm) {
        return new Options().algorithm(algorithm);
    }

    public static Options cpuBudget(Long cpuBudget) {
        return new Options().cpuBudget(cpuBudget);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<Object> asOutput() {
        return this.handle;
    }

    private ModelDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private Long algorithm;
        private Long cpuBudget;

        public Options algorithm(Long algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Options cpuBudget(Long cpuBudget) {
            this.cpuBudget = cpuBudget;
            return this;
        }

        private Options() {
        }
    }
}

