/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class RaggedTensorToTensor<U>
extends PrimitiveOp
implements Operand<U> {
    private Output<U> result;

    public static <U, T extends Number, V extends Number> RaggedTensorToTensor<U> create(Scope scope, Operand<T> shape, Operand<U> values, Operand<U> defaultValue, Iterable<Operand<V>> rowPartitionTensors, List<String> rowPartitionTypes) {
        OperationBuilder opBuilder = scope.env().opBuilder("RaggedTensorToTensor", scope.makeOpName("RaggedTensorToTensor"));
        opBuilder.addInput(shape.asOutput());
        opBuilder.addInput(values.asOutput());
        opBuilder.addInput(defaultValue.asOutput());
        opBuilder.addInputList(Operands.asOutputs(rowPartitionTensors));
        opBuilder = scope.applyControlDependencies(opBuilder);
        String[] rowPartitionTypesArray = new String[rowPartitionTypes.size()];
        for (int i = 0; i < rowPartitionTypesArray.length; ++i) {
            rowPartitionTypesArray[i] = rowPartitionTypes.get(i);
        }
        opBuilder.setAttr("row_partition_types", rowPartitionTypesArray);
        return new RaggedTensorToTensor<U>(opBuilder.build());
    }

    public Output<U> result() {
        return this.result;
    }

    @Override
    public Output<U> asOutput() {
        return this.result;
    }

    private RaggedTensorToTensor(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.result = operation.output(outputIdx++);
    }
}

