/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.op.Scope;
import org.tensorflow.op.nn.AvgPool;
import org.tensorflow.op.nn.AvgPool3d;
import org.tensorflow.op.nn.AvgPool3dGrad;
import org.tensorflow.op.nn.BatchNormWithGlobalNormalization;
import org.tensorflow.op.nn.BatchNormWithGlobalNormalizationGrad;
import org.tensorflow.op.nn.BiasAdd;
import org.tensorflow.op.nn.BiasAddGrad;
import org.tensorflow.op.nn.ComputeAccidentalHits;
import org.tensorflow.op.nn.Conv2d;
import org.tensorflow.op.nn.Conv2dBackpropFilter;
import org.tensorflow.op.nn.Conv2dBackpropInput;
import org.tensorflow.op.nn.Conv3d;
import org.tensorflow.op.nn.Conv3dBackpropFilter;
import org.tensorflow.op.nn.Conv3dBackpropInput;
import org.tensorflow.op.nn.CtcBeamSearchDecoder;
import org.tensorflow.op.nn.CtcGreedyDecoder;
import org.tensorflow.op.nn.CtcLoss;
import org.tensorflow.op.nn.CudnnRnnCanonicalToParams;
import org.tensorflow.op.nn.CudnnRnnParamsSize;
import org.tensorflow.op.nn.CudnnRnnParamsToCanonical;
import org.tensorflow.op.nn.DataFormatDimMap;
import org.tensorflow.op.nn.DataFormatVecPermute;
import org.tensorflow.op.nn.DepthToSpace;
import org.tensorflow.op.nn.DepthwiseConv2dNative;
import org.tensorflow.op.nn.DepthwiseConv2dNativeBackpropFilter;
import org.tensorflow.op.nn.DepthwiseConv2dNativeBackpropInput;
import org.tensorflow.op.nn.Dilation2d;
import org.tensorflow.op.nn.Dilation2dBackpropFilter;
import org.tensorflow.op.nn.Dilation2dBackpropInput;
import org.tensorflow.op.nn.Elu;
import org.tensorflow.op.nn.FixedUnigramCandidateSampler;
import org.tensorflow.op.nn.FractionalAvgPool;
import org.tensorflow.op.nn.FractionalMaxPool;
import org.tensorflow.op.nn.FusedBatchNorm;
import org.tensorflow.op.nn.FusedBatchNormGrad;
import org.tensorflow.op.nn.FusedPadConv2d;
import org.tensorflow.op.nn.FusedResizeAndPadConv2d;
import org.tensorflow.op.nn.InTopK;
import org.tensorflow.op.nn.L2Loss;
import org.tensorflow.op.nn.LearnedUnigramCandidateSampler;
import org.tensorflow.op.nn.LocalResponseNormalization;
import org.tensorflow.op.nn.LogSoftmax;
import org.tensorflow.op.nn.MaxPool;
import org.tensorflow.op.nn.MaxPool3d;
import org.tensorflow.op.nn.MaxPool3dGrad;
import org.tensorflow.op.nn.MaxPool3dGradGrad;
import org.tensorflow.op.nn.MaxPoolGrad;
import org.tensorflow.op.nn.MaxPoolGradGrad;
import org.tensorflow.op.nn.MaxPoolGradGradWithArgmax;
import org.tensorflow.op.nn.MaxPoolWithArgmax;
import org.tensorflow.op.nn.NthElement;
import org.tensorflow.op.nn.QuantizedAvgPool;
import org.tensorflow.op.nn.QuantizedBatchNormWithGlobalNormalization;
import org.tensorflow.op.nn.QuantizedBiasAdd;
import org.tensorflow.op.nn.QuantizedConv2d;
import org.tensorflow.op.nn.QuantizedInstanceNorm;
import org.tensorflow.op.nn.QuantizedMaxPool;
import org.tensorflow.op.nn.QuantizedRelu;
import org.tensorflow.op.nn.QuantizedRelu6;
import org.tensorflow.op.nn.QuantizedReluX;
import org.tensorflow.op.nn.Relu;
import org.tensorflow.op.nn.Relu6;
import org.tensorflow.op.nn.Selu;
import org.tensorflow.op.nn.Softmax;
import org.tensorflow.op.nn.SoftmaxCrossEntropyWithLogits;
import org.tensorflow.op.nn.Softsign;
import org.tensorflow.op.nn.SpaceToBatch;
import org.tensorflow.op.nn.SpaceToDepth;
import org.tensorflow.op.nn.SparseSoftmaxCrossEntropyWithLogits;
import org.tensorflow.op.nn.TopK;

public final class NnOps {
    private final Scope scope;

    NnOps(Scope scope) {
        this.scope = scope;
    }

    public <T extends Number> TopK<T> topK(Operand<T> input, Operand<Integer> k, TopK.Options ... options) {
        return TopK.create(this.scope, input, k, options);
    }

    public <T extends Number> DepthwiseConv2dNative<T> depthwiseConv2dNative(Operand<T> input, Operand<T> filter, List<Long> strides, String padding, DepthwiseConv2dNative.Options ... options) {
        return DepthwiseConv2dNative.create(this.scope, input, filter, strides, padding, options);
    }

    public <T> QuantizedInstanceNorm<T> quantizedInstanceNorm(Operand<T> x, Operand<Float> xMin, Operand<Float> xMax, QuantizedInstanceNorm.Options ... options) {
        return QuantizedInstanceNorm.create(this.scope, x, xMin, xMax, options);
    }

    public <T, U extends Number> SpaceToBatch<T> spaceToBatch(Operand<T> input, Operand<U> paddings, Long blockSize) {
        return SpaceToBatch.create(this.scope, input, paddings, blockSize);
    }

    public <T> DepthToSpace<T> depthToSpace(Operand<T> input, Long blockSize, DepthToSpace.Options ... options) {
        return DepthToSpace.create(this.scope, input, blockSize, options);
    }

    public <T extends Number> Softsign<T> softsign(Operand<T> features) {
        return Softsign.create(this.scope, features);
    }

    public <T extends Number> Conv3d<T> conv3d(Operand<T> input, Operand<T> filter, List<Long> strides, String padding, Conv3d.Options ... options) {
        return Conv3d.create(this.scope, input, filter, strides, padding, options);
    }

    public <U, T> QuantizedReluX<U> quantizedReluX(Operand<T> features, Operand<Float> maxValue, Operand<Float> minFeatures, Operand<Float> maxFeatures, Class<U> outType) {
        return QuantizedReluX.create(this.scope, features, maxValue, minFeatures, maxFeatures, outType);
    }

    public <T extends Number> MaxPoolWithArgmax<T, Long> maxPoolWithArgmax(Operand<T> input, List<Long> ksize, List<Long> strides, String padding, MaxPoolWithArgmax.Options ... options) {
        return MaxPoolWithArgmax.create(this.scope, input, ksize, strides, padding, options);
    }

    public <T extends Number> Conv2dBackpropInput<T> conv2dBackpropInput(Operand<Integer> inputSizes, Operand<T> filter, Operand<T> outBackprop, List<Long> strides, String padding, Conv2dBackpropInput.Options ... options) {
        return Conv2dBackpropInput.create(this.scope, inputSizes, filter, outBackprop, strides, padding, options);
    }

    public ComputeAccidentalHits computeAccidentalHits(Operand<Long> trueClasses, Operand<Long> sampledCandidates, Long numTrue, ComputeAccidentalHits.Options ... options) {
        return ComputeAccidentalHits.create(this.scope, trueClasses, sampledCandidates, numTrue, options);
    }

    public <U extends Number, T extends Number> MaxPool3dGrad<U> maxPool3dGrad(Operand<T> origInput, Operand<T> origOutput, Operand<U> grad, List<Long> ksize, List<Long> strides, String padding, MaxPool3dGrad.Options ... options) {
        return MaxPool3dGrad.create(this.scope, origInput, origOutput, grad, ksize, strides, padding, options);
    }

    public <T extends Number> CudnnRnnCanonicalToParams<T> cudnnRnnCanonicalToParams(Operand<Integer> numLayers, Operand<Integer> numUnits, Operand<Integer> inputSize, Iterable<Operand<T>> weights, Iterable<Operand<T>> biases, CudnnRnnCanonicalToParams.Options ... options) {
        return CudnnRnnCanonicalToParams.create(this.scope, numLayers, numUnits, inputSize, weights, biases, options);
    }

    public FixedUnigramCandidateSampler fixedUnigramCandidateSampler(Operand<Long> trueClasses, Long numTrue, Long numSampled, Boolean unique, Long rangeMax, FixedUnigramCandidateSampler.Options ... options) {
        return FixedUnigramCandidateSampler.create(this.scope, trueClasses, numTrue, numSampled, unique, rangeMax, options);
    }

    public <T extends Number> AvgPool3d<T> avgPool3d(Operand<T> input, List<Long> ksize, List<Long> strides, String padding, AvgPool3d.Options ... options) {
        return AvgPool3d.create(this.scope, input, ksize, strides, padding, options);
    }

    public <T extends Number> Relu6<T> relu6(Operand<T> features) {
        return Relu6.create(this.scope, features);
    }

    public <T extends Number> Elu<T> elu(Operand<T> features) {
        return Elu.create(this.scope, features);
    }

    public <T extends Number> CtcLoss<T> ctcLoss(Operand<T> inputs, Operand<Long> labelsIndices, Operand<Integer> labelsValues, Operand<Integer> sequenceLength, CtcLoss.Options ... options) {
        return CtcLoss.create(this.scope, inputs, labelsIndices, labelsValues, sequenceLength, options);
    }

    public <T extends Number> Conv3dBackpropFilter<T> conv3dBackpropFilter(Operand<T> input, Operand<Integer> filterSizes, Operand<T> outBackprop, List<Long> strides, String padding, Conv3dBackpropFilter.Options ... options) {
        return Conv3dBackpropFilter.create(this.scope, input, filterSizes, outBackprop, strides, padding, options);
    }

    public <T extends Number> CudnnRnnParamsToCanonical<T> cudnnRnnParamsToCanonical(Operand<Integer> numLayers, Operand<Integer> numUnits, Operand<Integer> inputSize, Operand<T> params, Long numParams, CudnnRnnParamsToCanonical.Options ... options) {
        return CudnnRnnParamsToCanonical.create(this.scope, numLayers, numUnits, inputSize, params, numParams, options);
    }

    public <T extends Number> FusedPadConv2d<T> fusedPadConv2d(Operand<T> input, Operand<Integer> paddings, Operand<T> filter, String mode, List<Long> strides, String padding) {
        return FusedPadConv2d.create(this.scope, input, paddings, filter, mode, strides, padding);
    }

    public <U, T> QuantizedRelu6<U> quantizedRelu6(Operand<T> features, Operand<Float> minFeatures, Operand<Float> maxFeatures, Class<U> outType) {
        return QuantizedRelu6.create(this.scope, features, minFeatures, maxFeatures, outType);
    }

    public <T extends Number> Conv2dBackpropFilter<T> conv2dBackpropFilter(Operand<T> input, Operand<Integer> filterSizes, Operand<T> outBackprop, List<Long> strides, String padding, Conv2dBackpropFilter.Options ... options) {
        return Conv2dBackpropFilter.create(this.scope, input, filterSizes, outBackprop, strides, padding, options);
    }

    public <T extends Number> FusedResizeAndPadConv2d<T> fusedResizeAndPadConv2d(Operand<T> input, Operand<Integer> size, Operand<Integer> paddings, Operand<T> filter, String mode, List<Long> strides, String padding, FusedResizeAndPadConv2d.Options ... options) {
        return FusedResizeAndPadConv2d.create(this.scope, input, size, paddings, filter, mode, strides, padding, options);
    }

    public <T extends Number> CtcGreedyDecoder<T> ctcGreedyDecoder(Operand<T> inputs, Operand<Integer> sequenceLength, CtcGreedyDecoder.Options ... options) {
        return CtcGreedyDecoder.create(this.scope, inputs, sequenceLength, options);
    }

    public <T extends Number> DataFormatDimMap<T> dataFormatDimMap(Operand<T> x, DataFormatDimMap.Options ... options) {
        return DataFormatDimMap.create(this.scope, x, options);
    }

    public <T extends Number, U extends Number> SparseSoftmaxCrossEntropyWithLogits<T> sparseSoftmaxCrossEntropyWithLogits(Operand<T> features, Operand<U> labels) {
        return SparseSoftmaxCrossEntropyWithLogits.create(this.scope, features, labels);
    }

    public <T extends Number, U extends Number> FusedBatchNormGrad<T, U> fusedBatchNormGrad(Operand<T> yBackprop, Operand<T> x, Operand<Float> scale, Operand<U> reserveSpace1, Operand<U> reserveSpace2, FusedBatchNormGrad.Options ... options) {
        return FusedBatchNormGrad.create(this.scope, yBackprop, x, scale, reserveSpace1, reserveSpace2, options);
    }

    public <T extends Number> MaxPoolGradGrad<T> maxPoolGradGrad(Operand<T> origInput, Operand<T> origOutput, Operand<T> grad, Operand<Integer> ksize, Operand<Integer> strides, String padding, MaxPoolGradGrad.Options ... options) {
        return MaxPoolGradGrad.create(this.scope, origInput, origOutput, grad, ksize, strides, padding, options);
    }

    public LearnedUnigramCandidateSampler learnedUnigramCandidateSampler(Operand<Long> trueClasses, Long numTrue, Long numSampled, Boolean unique, Long rangeMax, LearnedUnigramCandidateSampler.Options ... options) {
        return LearnedUnigramCandidateSampler.create(this.scope, trueClasses, numTrue, numSampled, unique, rangeMax, options);
    }

    public <T> Relu<T> relu(Operand<T> features) {
        return Relu.create(this.scope, features);
    }

    public <T> SpaceToDepth<T> spaceToDepth(Operand<T> input, Long blockSize, SpaceToDepth.Options ... options) {
        return SpaceToDepth.create(this.scope, input, blockSize, options);
    }

    public <T extends Number, U extends Number> FusedBatchNorm<T, U> fusedBatchNorm(Operand<T> x, Operand<U> scale, Operand<U> offset, Operand<U> mean, Operand<U> variance, FusedBatchNorm.Options ... options) {
        return FusedBatchNorm.create(this.scope, x, scale, offset, mean, variance, options);
    }

    public <T> MaxPool<T> maxPool(Operand<T> input, Operand<Integer> ksize, Operand<Integer> strides, String padding, MaxPool.Options ... options) {
        return MaxPool.create(this.scope, input, ksize, strides, padding, options);
    }

    public <V, T, U> QuantizedConv2d<V> quantizedConv2d(Operand<T> input, Operand<U> filter, Operand<Float> minInput, Operand<Float> maxInput, Operand<Float> minFilter, Operand<Float> maxFilter, Class<V> outType, List<Long> strides, String padding, QuantizedConv2d.Options ... options) {
        return QuantizedConv2d.create(this.scope, input, filter, minInput, maxInput, minFilter, maxFilter, outType, strides, padding, options);
    }

    public <T extends Number> LocalResponseNormalization<T> localResponseNormalization(Operand<T> input, LocalResponseNormalization.Options ... options) {
        return LocalResponseNormalization.create(this.scope, input, options);
    }

    public <U, T> QuantizedRelu<U> quantizedRelu(Operand<T> features, Operand<Float> minFeatures, Operand<Float> maxFeatures, Class<U> outType) {
        return QuantizedRelu.create(this.scope, features, minFeatures, maxFeatures, outType);
    }

    public <T extends Number> Dilation2d<T> dilation2d(Operand<T> input, Operand<T> filter, List<Long> strides, List<Long> rates, String padding) {
        return Dilation2d.create(this.scope, input, filter, strides, rates, padding);
    }

    public <T extends Number> MaxPoolGrad<T> maxPoolGrad(Operand<T> origInput, Operand<T> origOutput, Operand<T> grad, Operand<Integer> ksize, Operand<Integer> strides, String padding, MaxPoolGrad.Options ... options) {
        return MaxPoolGrad.create(this.scope, origInput, origOutput, grad, ksize, strides, padding, options);
    }

    public <U extends Number, T extends Number> Conv3dBackpropInput<U> conv3dBackpropInput(Operand<T> inputSizes, Operand<U> filter, Operand<U> outBackprop, List<Long> strides, String padding, Conv3dBackpropInput.Options ... options) {
        return Conv3dBackpropInput.create(this.scope, inputSizes, filter, outBackprop, strides, padding, options);
    }

    public <T extends Number> NthElement<T> nthElement(Operand<T> input, Operand<Integer> n, NthElement.Options ... options) {
        return NthElement.create(this.scope, input, n, options);
    }

    public <T extends Number> DataFormatVecPermute<T> dataFormatVecPermute(Operand<T> x, DataFormatVecPermute.Options ... options) {
        return DataFormatVecPermute.create(this.scope, x, options);
    }

    public <T> QuantizedMaxPool<T> quantizedMaxPool(Operand<T> input, Operand<Float> minInput, Operand<Float> maxInput, List<Long> ksize, List<Long> strides, String padding) {
        return QuantizedMaxPool.create(this.scope, input, minInput, maxInput, ksize, strides, padding);
    }

    public <T extends Number> Softmax<T> softmax(Operand<T> logits) {
        return Softmax.create(this.scope, logits);
    }

    public <T> BiasAddGrad<T> biasAddGrad(Operand<T> outBackprop, BiasAddGrad.Options ... options) {
        return BiasAddGrad.create(this.scope, outBackprop, options);
    }

    public <T> BatchNormWithGlobalNormalizationGrad<T> batchNormWithGlobalNormalizationGrad(Operand<T> t, Operand<T> m, Operand<T> v, Operand<T> gamma, Operand<T> backprop, Float varianceEpsilon, Boolean scaleAfterNormalization) {
        return BatchNormWithGlobalNormalizationGrad.create(this.scope, t, m, v, gamma, backprop, varianceEpsilon, scaleAfterNormalization);
    }

    public <T extends Number> Dilation2dBackpropFilter<T> dilation2dBackpropFilter(Operand<T> input, Operand<T> filter, Operand<T> outBackprop, List<Long> strides, List<Long> rates, String padding) {
        return Dilation2dBackpropFilter.create(this.scope, input, filter, outBackprop, strides, rates, padding);
    }

    public <T extends Number, U extends Number> MaxPoolWithArgmax<T, U> maxPoolWithArgmax(Operand<T> input, List<Long> ksize, List<Long> strides, Class<U> Targmax, String padding, MaxPoolWithArgmax.Options ... options) {
        return MaxPoolWithArgmax.create(this.scope, input, ksize, strides, Targmax, padding, options);
    }

    public <T extends Number> AvgPool3dGrad<T> avgPool3dGrad(Operand<Integer> origInputShape, Operand<T> grad, List<Long> ksize, List<Long> strides, String padding, AvgPool3dGrad.Options ... options) {
        return AvgPool3dGrad.create(this.scope, origInputShape, grad, ksize, strides, padding, options);
    }

    public <T extends Number> InTopK inTopK(Operand<Float> predictions, Operand<T> targets, Operand<T> k) {
        return InTopK.create(this.scope, predictions, targets, k);
    }

    public <U extends Number, T extends Number> CudnnRnnParamsSize<U> cudnnRnnParamsSize(Operand<Integer> numLayers, Operand<Integer> numUnits, Operand<Integer> inputSize, Class<T> T, Class<U> S, CudnnRnnParamsSize.Options ... options) {
        return CudnnRnnParamsSize.create(this.scope, numLayers, numUnits, inputSize, T, S, options);
    }

    public <T extends Number> Dilation2dBackpropInput<T> dilation2dBackpropInput(Operand<T> input, Operand<T> filter, Operand<T> outBackprop, List<Long> strides, List<Long> rates, String padding) {
        return Dilation2dBackpropInput.create(this.scope, input, filter, outBackprop, strides, rates, padding);
    }

    public <T> QuantizedAvgPool<T> quantizedAvgPool(Operand<T> input, Operand<Float> minInput, Operand<Float> maxInput, List<Long> ksize, List<Long> strides, String padding) {
        return QuantizedAvgPool.create(this.scope, input, minInput, maxInput, ksize, strides, padding);
    }

    public <T> BatchNormWithGlobalNormalization<T> batchNormWithGlobalNormalization(Operand<T> t, Operand<T> m, Operand<T> v, Operand<T> beta, Operand<T> gamma, Float varianceEpsilon, Boolean scaleAfterNormalization) {
        return BatchNormWithGlobalNormalization.create(this.scope, t, m, v, beta, gamma, varianceEpsilon, scaleAfterNormalization);
    }

    public <T extends Number> Selu<T> selu(Operand<T> features) {
        return Selu.create(this.scope, features);
    }

    public <T extends Number> LogSoftmax<T> logSoftmax(Operand<T> logits) {
        return LogSoftmax.create(this.scope, logits);
    }

    public <T extends Number> CtcBeamSearchDecoder<T> ctcBeamSearchDecoder(Operand<T> inputs, Operand<Integer> sequenceLength, Long beamWidth, Long topPaths, CtcBeamSearchDecoder.Options ... options) {
        return CtcBeamSearchDecoder.create(this.scope, inputs, sequenceLength, beamWidth, topPaths, options);
    }

    public <T extends Number> FractionalAvgPool<T> fractionalAvgPool(Operand<T> value, List<Float> poolingRatio, FractionalAvgPool.Options ... options) {
        return FractionalAvgPool.create(this.scope, value, poolingRatio, options);
    }

    public <T extends Number> Conv2d<T> conv2d(Operand<T> input, Operand<T> filter, List<Long> strides, String padding, Conv2d.Options ... options) {
        return Conv2d.create(this.scope, input, filter, strides, padding, options);
    }

    public <T extends Number> L2Loss<T> l2Loss(Operand<T> t) {
        return L2Loss.create(this.scope, t);
    }

    public <T extends Number> MaxPool3d<T> maxPool3d(Operand<T> input, List<Long> ksize, List<Long> strides, String padding, MaxPool3d.Options ... options) {
        return MaxPool3d.create(this.scope, input, ksize, strides, padding, options);
    }

    public <V, T, U> QuantizedBiasAdd<V> quantizedBiasAdd(Operand<T> input, Operand<U> bias, Operand<Float> minInput, Operand<Float> maxInput, Operand<Float> minBias, Operand<Float> maxBias, Class<V> outType) {
        return QuantizedBiasAdd.create(this.scope, input, bias, minInput, maxInput, minBias, maxBias, outType);
    }

    public <T extends Number> DepthwiseConv2dNativeBackpropInput<T> depthwiseConv2dNativeBackpropInput(Operand<Integer> inputSizes, Operand<T> filter, Operand<T> outBackprop, List<Long> strides, String padding, DepthwiseConv2dNativeBackpropInput.Options ... options) {
        return DepthwiseConv2dNativeBackpropInput.create(this.scope, inputSizes, filter, outBackprop, strides, padding, options);
    }

    public <T extends Number> SoftmaxCrossEntropyWithLogits<T> softmaxCrossEntropyWithLogits(Operand<T> features, Operand<T> labels) {
        return SoftmaxCrossEntropyWithLogits.create(this.scope, features, labels);
    }

    public <T extends Number> MaxPool3dGradGrad<T> maxPool3dGradGrad(Operand<T> origInput, Operand<T> origOutput, Operand<T> grad, List<Long> ksize, List<Long> strides, String padding, MaxPool3dGradGrad.Options ... options) {
        return MaxPool3dGradGrad.create(this.scope, origInput, origOutput, grad, ksize, strides, padding, options);
    }

    public <U, T> QuantizedBatchNormWithGlobalNormalization<U> quantizedBatchNormWithGlobalNormalization(Operand<T> t, Operand<Float> tMin, Operand<Float> tMax, Operand<T> m, Operand<Float> mMin, Operand<Float> mMax, Operand<T> v, Operand<Float> vMin, Operand<Float> vMax, Operand<T> beta, Operand<Float> betaMin, Operand<Float> betaMax, Operand<T> gamma, Operand<Float> gammaMin, Operand<Float> gammaMax, Class<U> outType, Float varianceEpsilon, Boolean scaleAfterNormalization) {
        return QuantizedBatchNormWithGlobalNormalization.create(this.scope, t, tMin, tMax, m, mMin, mMax, v, vMin, vMax, beta, betaMin, betaMax, gamma, gammaMin, gammaMax, outType, varianceEpsilon, scaleAfterNormalization);
    }

    public <T extends Number, U extends Number> MaxPoolGradGradWithArgmax<T> maxPoolGradGradWithArgmax(Operand<T> input, Operand<T> grad, Operand<U> argmax, List<Long> ksize, List<Long> strides, String padding, MaxPoolGradGradWithArgmax.Options ... options) {
        return MaxPoolGradGradWithArgmax.create(this.scope, input, grad, argmax, ksize, strides, padding, options);
    }

    public <T extends Number> FractionalMaxPool<T> fractionalMaxPool(Operand<T> value, List<Float> poolingRatio, FractionalMaxPool.Options ... options) {
        return FractionalMaxPool.create(this.scope, value, poolingRatio, options);
    }

    public <T extends Number> AvgPool<T> avgPool(Operand<T> value, List<Long> ksize, List<Long> strides, String padding, AvgPool.Options ... options) {
        return AvgPool.create(this.scope, value, ksize, strides, padding, options);
    }

    public <T> BiasAdd<T> biasAdd(Operand<T> value, Operand<T> bias, BiasAdd.Options ... options) {
        return BiasAdd.create(this.scope, value, bias, options);
    }

    public <T extends Number> DepthwiseConv2dNativeBackpropFilter<T> depthwiseConv2dNativeBackpropFilter(Operand<T> input, Operand<Integer> filterSizes, Operand<T> outBackprop, List<Long> strides, String padding, DepthwiseConv2dNativeBackpropFilter.Options ... options) {
        return DepthwiseConv2dNativeBackpropFilter.create(this.scope, input, filterSizes, outBackprop, strides, padding, options);
    }
}

