/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Configures the credentials used by the GCS client of the local TF runtime.
 * <p>
 * The json input can be of the format:
 * <p>
 * 1. Refresh Token:
 * {
 *   "client_id": "<redacted>",
 *   "client_secret": "<redacted>",
 *   "refresh_token: "<redacted>",
 *   "type": "authorized_user",
 * }
 * <p>
 * 2. Service Account:
 * {
 *   "type": "service_account",
 *   "project_id": "<redacted>",
 *   "private_key_id": "<redacted>",
 *   "private_key": "------BEGIN PRIVATE KEY-----\n<REDACTED>\n-----END PRIVATE KEY------\n",
 *   "client_email": "<REDACTED>@<REDACTED>.iam.gserviceaccount.com",
 *   "client_id": "<REDACTED>",
 *   # Some additional fields elided
 * }
 * <p>
 * Note the credentials established through this method are shared across all
 * sessions run on this runtime.
 * <p>
 * Note be sure to feed the inputs to this op to ensure the credentials are not
 * stored in a constant op within the graph that might accidentally be checkpointed
 * or in other ways be persisted or exfiltrated.
 */
@Operator
public final class GcsConfigureCredentials extends PrimitiveOp {
  
  /**
   * Factory method to create a class wrapping a new GcsConfigureCredentials operation.
   * 
   * @param scope current scope
   * @param json 
   * @return a new instance of GcsConfigureCredentials
   */
  public static GcsConfigureCredentials create(Scope scope, Operand<String> json) {
    OperationBuilder opBuilder = scope.env().opBuilder("GcsConfigureCredentials", scope.makeOpName("GcsConfigureCredentials"));
    opBuilder.addInput(json.asOutput());
    opBuilder = scope.applyControlDependencies(opBuilder);
    return new GcsConfigureCredentials(opBuilder.build());
  }
  
  
  private GcsConfigureCredentials(Operation operation) {
    super(operation);
  }
}
