/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.strings;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class UnicodeDecodeWithOffsets<T extends Number>
extends PrimitiveOp {
    private Output<T> rowSplits;
    private Output<Integer> charValues;
    private Output<Long> charToByteStarts;

    public static <T extends Number> UnicodeDecodeWithOffsets<T> create(Scope scope, Operand<String> input, String inputEncoding, Class<T> Tsplits, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("UnicodeDecodeWithOffsets", scope.makeOpName("UnicodeDecodeWithOffsets"));
        opBuilder.addInput(input.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("input_encoding", inputEncoding);
        opBuilder.setAttr("Tsplits", DataType.fromClass(Tsplits));
        if (options != null) {
            for (Options opts : options) {
                if (opts.errors != null) {
                    opBuilder.setAttr("errors", opts.errors);
                }
                if (opts.replacementChar != null) {
                    opBuilder.setAttr("replacement_char", opts.replacementChar);
                }
                if (opts.replaceControlCharacters == null) continue;
                opBuilder.setAttr("replace_control_characters", opts.replaceControlCharacters);
            }
        }
        return new UnicodeDecodeWithOffsets<T>(opBuilder.build());
    }

    public static UnicodeDecodeWithOffsets<Long> create(Scope scope, Operand<String> input, String inputEncoding, Options ... options) {
        return UnicodeDecodeWithOffsets.create(scope, input, inputEncoding, Long.class, options);
    }

    public static Options errors(String errors) {
        return new Options().errors(errors);
    }

    public static Options replacementChar(Long replacementChar) {
        return new Options().replacementChar(replacementChar);
    }

    public static Options replaceControlCharacters(Boolean replaceControlCharacters) {
        return new Options().replaceControlCharacters(replaceControlCharacters);
    }

    public Output<T> rowSplits() {
        return this.rowSplits;
    }

    public Output<Integer> charValues() {
        return this.charValues;
    }

    public Output<Long> charToByteStarts() {
        return this.charToByteStarts;
    }

    private UnicodeDecodeWithOffsets(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.rowSplits = operation.output(outputIdx++);
        this.charValues = operation.output(outputIdx++);
        this.charToByteStarts = operation.output(outputIdx++);
    }

    public static class Options {
        private String errors;
        private Long replacementChar;
        private Boolean replaceControlCharacters;

        public Options errors(String errors) {
            this.errors = errors;
            return this;
        }

        public Options replacementChar(Long replacementChar) {
            this.replacementChar = replacementChar;
            return this;
        }

        public Options replaceControlCharacters(Boolean replaceControlCharacters) {
            this.replaceControlCharacters = replaceControlCharacters;
            return this;
        }

        private Options() {
        }
    }
}

