/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Bucketize
extends PrimitiveOp
implements Operand<Integer> {
    private Output<Integer> output;

    public static <T extends Number> Bucketize create(Scope scope, Operand<T> input, List<Float> boundaries) {
        OperationBuilder opBuilder = scope.env().opBuilder("Bucketize", scope.makeOpName("Bucketize"));
        opBuilder.addInput(input.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        float[] boundariesArray = new float[boundaries.size()];
        for (int i = 0; i < boundariesArray.length; ++i) {
            boundariesArray[i] = boundaries.get(i).floatValue();
        }
        opBuilder.setAttr("boundaries", boundariesArray);
        return new Bucketize(opBuilder.build());
    }

    public Output<Integer> output() {
        return this.output;
    }

    @Override
    public Output<Integer> asOutput() {
        return this.output;
    }

    private Bucketize(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }
}

