/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Saves the input tensors to disk.
 * <p>
 * The size of `tensor_names` must match the number of tensors in `data`. `data[i]`
 * is written to `filename` with name `tensor_names[i]`.
 * <p>
 * See also `SaveSlices`.
 */
@Operator
public final class Save extends PrimitiveOp {
  
  /**
   * Factory method to create a class to wrap a new Save operation to the graph.
   * 
   * @param scope current graph scope
   * @param filename Must have a single element. The name of the file to which we write
   * the tensor.
   * @param tensorNames Shape `[N]`. The names of the tensors to be saved.
   * @param data `N` tensors to save.
   * @return a new instance of Save
   */
  public static Save create(Scope scope, Operand<String> filename, Operand<String> tensorNames, Iterable<Operand<?>> data) {
    OperationBuilder opBuilder = scope.graph().opBuilder("Save", scope.makeOpName("Save"));
    opBuilder.addInput(filename.asOutput());
    opBuilder.addInput(tensorNames.asOutput());
    opBuilder.addInputList(Operands.asOutputs(data));
    return new Save(opBuilder.build());
  }
  
  
  private Save(Operation operation) {
    super(operation);
  }
}
