/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Prints a list of tensors.
 * <p>
 * Passes `input` through to `output` and prints `data` when evaluating.
 * 
 * @param <T> data type for {@code output()} output
 */
@Operator
public final class Print<T> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.Print}
   */
  public static class Options {
    
    /**
     * @param message A string, prefix of the error message.
     */
    public Options message(String message) {
      this.message = message;
      return this;
    }
    
    /**
     * @param firstN Only log `first_n` number of times. -1 disables logging.
     */
    public Options firstN(Long firstN) {
      this.firstN = firstN;
      return this;
    }
    
    /**
     * @param summarize Only print this many entries of each tensor.
     */
    public Options summarize(Long summarize) {
      this.summarize = summarize;
      return this;
    }
    
    private String message;
    private Long firstN;
    private Long summarize;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new Print operation to the graph.
   * 
   * @param scope current graph scope
   * @param input The tensor passed to `output`
   * @param data A list of tensors to print out when op is evaluated.
   * @param options carries optional attributes values
   * @return a new instance of Print
   */
  public static <T> Print<T> create(Scope scope, Operand<T> input, Iterable<Operand<?>> data, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("Print", scope.makeOpName("Print"));
    opBuilder.addInput(input.asOutput());
    opBuilder.addInputList(Operands.asOutputs(data));
    if (options != null) {
      for (Options opts : options) {
        if (opts.message != null) {
          opBuilder.setAttr("message", opts.message);
        }
        if (opts.firstN != null) {
          opBuilder.setAttr("first_n", opts.firstN);
        }
        if (opts.summarize != null) {
          opBuilder.setAttr("summarize", opts.summarize);
        }
      }
    }
    return new Print<T>(opBuilder.build());
  }
  
  /**
   * @param message A string, prefix of the error message.
   */
  public static Options message(String message) {
    return new Options().message(message);
  }
  
  /**
   * @param firstN Only log `first_n` number of times. -1 disables logging.
   */
  public static Options firstN(Long firstN) {
    return new Options().firstN(firstN);
  }
  
  /**
   * @param summarize Only print this many entries of each tensor.
   */
  public static Options summarize(Long summarize) {
    return new Options().summarize(summarize);
  }
  
  /**
   * = The unmodified `input` tensor
   */
  public Output<T> output() {
    return output;
  }
  
  @Override
  public Output<T> asOutput() {
    return output;
  }
  
  private Output<T> output;
  
  private Print(Operation operation) {
    super(operation);
    int outputIdx = 0;
    output = operation.output(outputIdx++);
  }
}
