/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Computes the number of elements in the given table.
 */
@Operator
public final class LookupTableSize extends PrimitiveOp implements Operand<Long> {
  
  /**
   * Factory method to create a class to wrap a new LookupTableSize operation to the graph.
   * 
   * @param scope current graph scope
   * @param tableHandle Handle to the table.
   * @return a new instance of LookupTableSize
   */
  public static LookupTableSize create(Scope scope, Operand<?> tableHandle) {
    OperationBuilder opBuilder = scope.graph().opBuilder("LookupTableSizeV2", scope.makeOpName("LookupTableSize"));
    opBuilder.addInput(tableHandle.asOutput());
    return new LookupTableSize(opBuilder.build());
  }
  
  /**
   * Scalar that contains number of elements in the table.
   */
  public Output<Long> size() {
    return size;
  }
  
  @Override
  public Output<Long> asOutput() {
    return size;
  }
  
  private Output<Long> size;
  
  private LookupTableSize(Operation operation) {
    super(operation);
    int outputIdx = 0;
    size = operation.output(outputIdx++);
  }
}
