/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * The op serializes protobuf messages provided in the input tensors.
 * <p>
 * The types of the tensors in `values` must match the schema for the
 * fields specified in `field_names`. All the tensors in `values` must
 * have a common shape prefix, <i>batch_shape</i>.
 * <p>
 * The `sizes` tensor specifies repeat counts for each field.  The repeat
 * count (last dimension) of a each tensor in `values` must be greater
 * than or equal to corresponding repeat count in `sizes`.
 * <p>
 * A `message_type` name must be provided to give context for the field
 * names. The actual message descriptor can be looked up either in the
 * linked-in descriptor pool or a filename provided by the caller using
 * the `descriptor_source` attribute.
 * <p>
 * The `descriptor_source` attribute selects a source of protocol
 * descriptors to consult when looking up `message_type`. This may be a
 * filename containing a serialized `FileDescriptorSet` message,
 * or the special value `local://`, in which case only descriptors linked
 * into the code will be searched; the filename can be on any filesystem
 * accessible to TensorFlow.
 * <p>
 * You can build a `descriptor_source` file using the `--descriptor_set_out`
 * and `--include_imports` options to the protocol compiler `protoc`.
 * <p>
 * The `local://` database only covers descriptors linked into the
 * code via C++ libraries, not Python imports. You can link in a proto descriptor
 * by creating a cc_library target with alwayslink=1.
 * <p>
 * There are a few special cases in the value mapping:
 * <p>
 * Submessage and group fields must be pre-serialized as TensorFlow strings.
 * <p>
 * TensorFlow lacks support for unsigned int64s, so they must be
 * represented as `tf.int64` with the same twos-complement bit pattern
 * (the obvious way).
 * <p>
 * Unsigned int32 values can be represented exactly with `tf.int64`, or
 * with sign wrapping if the input is of type `tf.int32`.
 */
@Operator
public final class EncodeProto extends PrimitiveOp implements Operand<String> {
  
  /**
   * Optional attributes for {@link org.tensorflow.op.core.EncodeProto}
   */
  public static class Options {
    
    /**
     * @param descriptorSource 
     */
    public Options descriptorSource(String descriptorSource) {
      this.descriptorSource = descriptorSource;
      return this;
    }
    
    private String descriptorSource;
    
    private Options() {
    }
  }
  
  /**
   * Factory method to create a class to wrap a new EncodeProto operation to the graph.
   * 
   * @param scope current graph scope
   * @param sizes Tensor of int32 with shape `[batch_shape, len(field_names)]`.
   * @param values List of tensors containing values for the corresponding field.
   * @param fieldNames List of strings containing proto field names.
   * @param messageType Name of the proto message type to decode.
   * @param options carries optional attributes values
   * @return a new instance of EncodeProto
   */
  public static EncodeProto create(Scope scope, Operand<Integer> sizes, Iterable<Operand<?>> values, List<String> fieldNames, String messageType, Options... options) {
    OperationBuilder opBuilder = scope.graph().opBuilder("EncodeProto", scope.makeOpName("EncodeProto"));
    opBuilder.addInput(sizes.asOutput());
    opBuilder.addInputList(Operands.asOutputs(values));
    String[] fieldNamesArray = new String[fieldNames.size()];
    for (int i = 0; i < fieldNamesArray.length; ++i) {
      fieldNamesArray[i] = fieldNames.get(i);
    }
    opBuilder.setAttr("field_names", fieldNamesArray);
    opBuilder.setAttr("message_type", messageType);
    if (options != null) {
      for (Options opts : options) {
        if (opts.descriptorSource != null) {
          opBuilder.setAttr("descriptor_source", opts.descriptorSource);
        }
      }
    }
    return new EncodeProto(opBuilder.build());
  }
  
  /**
   * @param descriptorSource 
   */
  public static Options descriptorSource(String descriptorSource) {
    return new Options().descriptorSource(descriptorSource);
  }
  
  /**
   * Tensor of serialized protos with shape `batch_shape`.
   */
  public Output<String> bytes() {
    return bytes;
  }
  
  @Override
  public Output<String> asOutput() {
    return bytes;
  }
  
  private Output<String> bytes;
  
  private EncodeProto(Operation operation) {
    super(operation);
    int outputIdx = 0;
    bytes = operation.output(outputIdx++);
  }
}
