/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Computes the Cholesky decomposition of one or more square matrices.
 * <p>
 * The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
 * form square matrices.
 * <p>
 * The input has to be symmetric and positive definite. Only the lower-triangular
 * part of the input will be used for this operation. The upper-triangular part
 * will not be read.
 * <p>
 * The output is a tensor of the same shape as the input
 * containing the Cholesky decompositions for all input submatrices `[..., :, :]`.
 * <p>
 * <b>Note</b>: The gradient computation on GPU is faster for large matrices but
 * not for large batch dimensions when the submatrices are small. In this
 * case it might be faster to use the CPU.
 * 
 * @param <T> data type for {@code output()} output
 */
@Operator
public final class Cholesky<T> extends PrimitiveOp implements Operand<T> {
  
  /**
   * Factory method to create a class to wrap a new Cholesky operation to the graph.
   * 
   * @param scope current graph scope
   * @param input Shape is `[..., M, M]`.
   * @return a new instance of Cholesky
   */
  public static <T> Cholesky<T> create(Scope scope, Operand<T> input) {
    OperationBuilder opBuilder = scope.graph().opBuilder("Cholesky", scope.makeOpName("Cholesky"));
    opBuilder.addInput(input.asOutput());
    return new Cholesky<T>(opBuilder.build());
  }
  
  /**
   * Shape is `[..., M, M]`.
   */
  public Output<T> output() {
    return output;
  }
  
  @Override
  public Output<T> asOutput() {
    return output;
  }
  
  private Output<T> output;
  
  private Cholesky(Operation operation) {
    super(operation);
    int outputIdx = 0;
    output = operation.output(outputIdx++);
  }
}
