/* Copyright 2018 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
=======================================================================*/

// This class has been generated, DO NOT EDIT!

package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.Operator;

/**
 * Computes the number of complete elements in the given barrier.
 */
@Operator
public final class BarrierReadySize extends PrimitiveOp implements Operand<Integer> {
  
  /**
   * Factory method to create a class to wrap a new BarrierReadySize operation to the graph.
   * 
   * @param scope current graph scope
   * @param handle The handle to a barrier.
   * @return a new instance of BarrierReadySize
   */
  public static BarrierReadySize create(Scope scope, Operand<String> handle) {
    OperationBuilder opBuilder = scope.graph().opBuilder("BarrierReadySize", scope.makeOpName("BarrierReadySize"));
    opBuilder.addInput(handle.asOutput());
    return new BarrierReadySize(opBuilder.build());
  }
  
  /**
   * The number of complete elements (i.e. those with all of their value
   * components set) in the barrier.
   */
  public Output<Integer> size() {
    return size;
  }
  
  @Override
  public Output<Integer> asOutput() {
    return size;
  }
  
  private Output<Integer> size;
  
  private BarrierReadySize(Operation operation) {
    super(operation);
    int outputIdx = 0;
    size = operation.output(outputIdx++);
  }
}
