/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizeV2<T>
extends PrimitiveOp {
    private Output<T> output;
    private Output<Float> outputMin;
    private Output<Float> outputMax;

    public static <T> QuantizeV2<T> create(Scope scope, Operand<Float> input, Operand<Float> minRange, Operand<Float> maxRange, Class<T> T, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("QuantizeV2", scope.makeOpName("QuantizeV2"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(minRange.asOutput());
        opBuilder.addInput(maxRange.asOutput());
        opBuilder.setAttr("T", DataType.fromClass(T));
        if (options != null) {
            for (Options opts : options) {
                if (opts.mode != null) {
                    opBuilder.setAttr("mode", opts.mode);
                }
                if (opts.roundMode == null) continue;
                opBuilder.setAttr("round_mode", opts.roundMode);
            }
        }
        return new QuantizeV2<T>(opBuilder.build());
    }

    public static Options mode(String mode) {
        return new Options().mode(mode);
    }

    public static Options roundMode(String roundMode) {
        return new Options().roundMode(roundMode);
    }

    public Output<T> output() {
        return this.output;
    }

    public Output<Float> outputMin() {
        return this.outputMin;
    }

    public Output<Float> outputMax() {
        return this.outputMax;
    }

    private QuantizeV2(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.outputMin = operation.output(outputIdx++);
        this.outputMax = operation.output(outputIdx++);
    }

    public static class Options {
        private String mode;
        private String roundMode;

        public Options mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Options roundMode(String roundMode) {
            this.roundMode = roundMode;
            return this;
        }

        private Options() {
        }
    }
}

