/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizeAndDequantizeV2<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> QuantizeAndDequantizeV2<T> create(Scope scope, Operand<T> input, Operand<T> inputMin, Operand<T> inputMax, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("QuantizeAndDequantizeV2", scope.makeOpName("QuantizeAndDequantizeV2"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(inputMin.asOutput());
        opBuilder.addInput(inputMax.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.signedInput != null) {
                    opBuilder.setAttr("signed_input", opts.signedInput);
                }
                if (opts.numBits != null) {
                    opBuilder.setAttr("num_bits", opts.numBits);
                }
                if (opts.rangeGiven != null) {
                    opBuilder.setAttr("range_given", opts.rangeGiven);
                }
                if (opts.roundMode == null) continue;
                opBuilder.setAttr("round_mode", opts.roundMode);
            }
        }
        return new QuantizeAndDequantizeV2<T>(opBuilder.build());
    }

    public static Options signedInput(Boolean signedInput) {
        return new Options().signedInput(signedInput);
    }

    public static Options numBits(Long numBits) {
        return new Options().numBits(numBits);
    }

    public static Options rangeGiven(Boolean rangeGiven) {
        return new Options().rangeGiven(rangeGiven);
    }

    public static Options roundMode(String roundMode) {
        return new Options().roundMode(roundMode);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private QuantizeAndDequantizeV2(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean signedInput;
        private Long numBits;
        private Boolean rangeGiven;
        private String roundMode;

        public Options signedInput(Boolean signedInput) {
            this.signedInput = signedInput;
            return this;
        }

        public Options numBits(Long numBits) {
            this.numBits = numBits;
            return this;
        }

        public Options rangeGiven(Boolean rangeGiven) {
            this.rangeGiven = rangeGiven;
            return this;
        }

        public Options roundMode(String roundMode) {
            this.roundMode = roundMode;
            return this;
        }

        private Options() {
        }
    }
}

