/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TopK<T extends Number>
extends PrimitiveOp {
    private Output<T> values;
    private Output<Integer> indices;

    public static <T extends Number> TopK<T> create(Scope scope, Operand<T> input, Operand<Integer> k, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("TopKV2", scope.makeOpName("TopK"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(k.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.sorted == null) continue;
                opBuilder.setAttr("sorted", opts.sorted);
            }
        }
        return new TopK<T>(opBuilder.build());
    }

    public static Options sorted(Boolean sorted) {
        return new Options().sorted(sorted);
    }

    public Output<T> values() {
        return this.values;
    }

    public Output<Integer> indices() {
        return this.indices;
    }

    private TopK(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.values = operation.output(outputIdx++);
        this.indices = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean sorted;

        public Options sorted(Boolean sorted) {
            this.sorted = sorted;
            return this;
        }

        private Options() {
        }
    }
}

