/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class RandomPoissonV2<V extends Number>
extends PrimitiveOp
implements Operand<V> {
    private Output<V> output;

    public static <V extends Number, T extends Number, U extends Number> RandomPoissonV2<V> create(Scope scope, Operand<T> shape, Operand<U> rate, Class<V> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("RandomPoissonV2", scope.makeOpName("RandomPoissonV2"));
        opBuilder.addInput(shape.asOutput());
        opBuilder.addInput(rate.asOutput());
        opBuilder.setAttr("dtype", DataType.fromClass(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 == null) continue;
                opBuilder.setAttr("seed2", opts.seed2);
            }
        }
        return new RandomPoissonV2<V>(opBuilder.build());
    }

    public static <T extends Number, U extends Number> RandomPoissonV2<Long> create(Scope scope, Operand<T> shape, Operand<U> rate, Options ... options) {
        return RandomPoissonV2.create(scope, shape, rate, Long.class, options);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public Output<V> output() {
        return this.output;
    }

    @Override
    public Output<V> asOutput() {
        return this.output;
    }

    private RandomPoissonV2(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Long seed;
        private Long seed2;

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        private Options() {
        }
    }
}

