/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class InitializeTableFromTextFile
extends PrimitiveOp {
    public static InitializeTableFromTextFile create(Scope scope, Operand<?> tableHandle, Operand<String> filename, Long keyIndex, Long valueIndex, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("InitializeTableFromTextFileV2", scope.makeOpName("InitializeTableFromTextFile"));
        opBuilder.addInput(tableHandle.asOutput());
        opBuilder.addInput(filename.asOutput());
        opBuilder.setAttr("key_index", keyIndex);
        opBuilder.setAttr("value_index", valueIndex);
        if (options != null) {
            for (Options opts : options) {
                if (opts.vocabSize != null) {
                    opBuilder.setAttr("vocab_size", opts.vocabSize);
                }
                if (opts.delimiter == null) continue;
                opBuilder.setAttr("delimiter", opts.delimiter);
            }
        }
        return new InitializeTableFromTextFile(opBuilder.build());
    }

    public static Options vocabSize(Long vocabSize) {
        return new Options().vocabSize(vocabSize);
    }

    public static Options delimiter(String delimiter) {
        return new Options().delimiter(delimiter);
    }

    private InitializeTableFromTextFile(Operation operation) {
        super(operation);
    }

    public static class Options {
        private Long vocabSize;
        private String delimiter;

        public Options vocabSize(Long vocabSize) {
            this.vocabSize = vocabSize;
            return this;
        }

        public Options delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        private Options() {
        }
    }
}

