/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class FusedBatchNorm<T extends Number>
extends PrimitiveOp {
    private Output<T> y;
    private Output<T> batchMean;
    private Output<T> batchVariance;
    private Output<T> reserveSpace1;
    private Output<T> reserveSpace2;

    public static <T extends Number> FusedBatchNorm<T> create(Scope scope, Operand<T> x, Operand<T> scale, Operand<T> offset, Operand<T> mean, Operand<T> variance, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("FusedBatchNorm", scope.makeOpName("FusedBatchNorm"));
        opBuilder.addInput(x.asOutput());
        opBuilder.addInput(scale.asOutput());
        opBuilder.addInput(offset.asOutput());
        opBuilder.addInput(mean.asOutput());
        opBuilder.addInput(variance.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.epsilon != null) {
                    opBuilder.setAttr("epsilon", opts.epsilon.floatValue());
                }
                if (opts.dataFormat != null) {
                    opBuilder.setAttr("data_format", opts.dataFormat);
                }
                if (opts.isTraining == null) continue;
                opBuilder.setAttr("is_training", opts.isTraining);
            }
        }
        return new FusedBatchNorm<T>(opBuilder.build());
    }

    public static Options epsilon(Float epsilon) {
        return new Options().epsilon(epsilon);
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public static Options isTraining(Boolean isTraining) {
        return new Options().isTraining(isTraining);
    }

    public Output<T> y() {
        return this.y;
    }

    public Output<T> batchMean() {
        return this.batchMean;
    }

    public Output<T> batchVariance() {
        return this.batchVariance;
    }

    public Output<T> reserveSpace1() {
        return this.reserveSpace1;
    }

    public Output<T> reserveSpace2() {
        return this.reserveSpace2;
    }

    private FusedBatchNorm(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.y = operation.output(outputIdx++);
        this.batchMean = operation.output(outputIdx++);
        this.batchVariance = operation.output(outputIdx++);
        this.reserveSpace1 = operation.output(outputIdx++);
        this.reserveSpace2 = operation.output(outputIdx++);
    }

    public static class Options {
        private Float epsilon;
        private String dataFormat;
        private Boolean isTraining;

        public Options epsilon(Float epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Options isTraining(Boolean isTraining) {
            this.isTraining = isTraining;
            return this;
        }

        private Options() {
        }
    }
}

