/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DecodeProtoV2
extends PrimitiveOp {
    private Output<Integer> sizes;
    private List<Output<?>> values;

    public static DecodeProtoV2 create(Scope scope, Operand<String> bytes, String messageType, List<String> fieldNames, List<Class<?>> outputTypes, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("DecodeProtoV2", scope.makeOpName("DecodeProtoV2"));
        opBuilder.addInput(bytes.asOutput());
        opBuilder.setAttr("message_type", messageType);
        String[] fieldNamesArray = new String[fieldNames.size()];
        for (int i = 0; i < fieldNamesArray.length; ++i) {
            fieldNamesArray[i] = fieldNames.get(i);
        }
        opBuilder.setAttr("field_names", fieldNamesArray);
        DataType[] outputTypesArray = new DataType[outputTypes.size()];
        for (int i = 0; i < outputTypesArray.length; ++i) {
            outputTypesArray[i] = DataType.fromClass(outputTypes.get(i));
        }
        opBuilder.setAttr("output_types", outputTypesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.descriptorSource != null) {
                    opBuilder.setAttr("descriptor_source", opts.descriptorSource);
                }
                if (opts.messageFormat != null) {
                    opBuilder.setAttr("message_format", opts.messageFormat);
                }
                if (opts.sanitize == null) continue;
                opBuilder.setAttr("sanitize", opts.sanitize);
            }
        }
        return new DecodeProtoV2(opBuilder.build());
    }

    public static Options descriptorSource(String descriptorSource) {
        return new Options().descriptorSource(descriptorSource);
    }

    public static Options messageFormat(String messageFormat) {
        return new Options().messageFormat(messageFormat);
    }

    public static Options sanitize(Boolean sanitize) {
        return new Options().sanitize(sanitize);
    }

    public Output<Integer> sizes() {
        return this.sizes;
    }

    public List<Output<?>> values() {
        return this.values;
    }

    private DecodeProtoV2(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.sizes = operation.output(outputIdx++);
        int valuesLength = operation.outputListLength("values");
        this.values = Arrays.asList(operation.outputList(outputIdx, valuesLength));
        outputIdx += valuesLength;
    }

    public static class Options {
        private String descriptorSource;
        private String messageFormat;
        private Boolean sanitize;

        public Options descriptorSource(String descriptorSource) {
            this.descriptorSource = descriptorSource;
            return this;
        }

        public Options messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        public Options sanitize(Boolean sanitize) {
            this.sanitize = sanitize;
            return this;
        }

        private Options() {
        }
    }
}

