/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class AudioSummary
extends PrimitiveOp
implements Operand<String> {
    private Output<String> summary;

    public static AudioSummary create(Scope scope, Operand<String> tag, Operand<Float> tensor, Operand<Float> sampleRate, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("AudioSummaryV2", scope.makeOpName("AudioSummary"));
        opBuilder.addInput(tag.asOutput());
        opBuilder.addInput(tensor.asOutput());
        opBuilder.addInput(sampleRate.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.maxOutputs == null) continue;
                opBuilder.setAttr("max_outputs", opts.maxOutputs);
            }
        }
        return new AudioSummary(opBuilder.build());
    }

    public static Options maxOutputs(Long maxOutputs) {
        return new Options().maxOutputs(maxOutputs);
    }

    public Output<String> summary() {
        return this.summary;
    }

    @Override
    public Output<String> asOutput() {
        return this.summary;
    }

    private AudioSummary(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.summary = operation.output(outputIdx++);
    }

    public static class Options {
        private Long maxOutputs;

        public Options maxOutputs(Long maxOutputs) {
            this.maxOutputs = maxOutputs;
            return this;
        }

        private Options() {
        }
    }
}

